/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import java.awt.Insets;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

class CompoundEmptyBorder
extends CompoundBorder {
    private static final long serialVersionUID = -6542330524454421713L;
    protected static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected boolean inner;

    public static CompoundEmptyBorder create(Border border, boolean inner) {
        return CompoundEmptyBorder.create(border, inner, null);
    }

    public static CompoundEmptyBorder create(Border border, boolean inner, Insets base) {
        if (base == null) {
            base = new Insets(0, 0, 0, 0);
        }
        MutableEmptyBorder empty = new MutableEmptyBorder(base.top, base.left, base.bottom, base.right);
        if (inner) {
            return new CompoundEmptyBorder(border, empty, inner);
        }
        return new CompoundEmptyBorder(empty, border, inner);
    }

    protected CompoundEmptyBorder(Border outer, Border inner, boolean emptyInner) {
        super(outer, inner);
        this.inner = emptyInner;
    }

    public boolean setEmptyInsets(Insets insets) {
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        return this.setEmptyInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public boolean setEmptyInsets(int top, int left, int bottom, int right) {
        Border border = this.inner ? this.getInsideBorder() : this.getOutsideBorder();
        return ((MutableEmptyBorder)border).updateInsets(top, left, bottom, right);
    }

    public Insets getEmptyInsets() {
        Border border = this.inner ? this.getInsideBorder() : this.getOutsideBorder();
        MutableEmptyBorder empty = (MutableEmptyBorder)border;
        return empty.getBorderInsets();
    }

    public Border getWrappedBorder() {
        return this.inner ? this.getOutsideBorder() : this.getInsideBorder();
    }

    protected static class MutableEmptyBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 3931218790954979531L;

        public MutableEmptyBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }

        public MutableEmptyBorder(Insets borderInsets) {
            super(borderInsets);
        }

        private boolean updateInsets(int top, int left, int bottom, int right) {
            boolean changed = this.top != top || this.left != left || this.bottom != bottom || this.right != right;
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
            return changed;
        }
    }
}

