/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingPort;
import de.javasoft.docking.controls.IBorderManager;
import de.javasoft.docking.controls.IDockingPort;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BorderManager
implements IBorderManager {
    private Border assignedBorder;

    public BorderManager() {
    }

    public BorderManager(Border border) {
        this.setBorder(border);
    }

    public Border getBorder() {
        return this.assignedBorder;
    }

    public void setBorder(Border border) {
        this.assignedBorder = border;
    }

    @Override
    public void managePortNullChild(IDockingPort port) {
        this.setBorder(port, this.assignedBorder);
    }

    @Override
    public void managePortSimpleChild(IDockingPort port) {
        this.setBorder(port.getDockedComponent(), null);
        this.setBorder(port, this.assignedBorder);
    }

    @Override
    public void managePortSplitChild(IDockingPort port) {
        BasicSplitPaneDivider divider;
        if (port == null || !(port.getDockedComponent() instanceof JSplitPane)) {
            return;
        }
        this.setBorder(port, null);
        JSplitPane split = (JSplitPane)port.getDockedComponent();
        if (split.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)split.getUI()).getDivider()) != null && divider.getBorder() != null) {
            divider.setBorder(null);
        }
        this.setBorder(split, null);
        this.setSubComponentBorder(split.getLeftComponent(), this.assignedBorder);
        this.setSubComponentBorder(split.getRightComponent(), this.assignedBorder);
    }

    private void setSubComponentBorder(Component comp, Border border) {
        if (comp instanceof DockingPort) {
            ((DockingPort)comp).evaluateDockingBorderStatus();
        } else {
            this.setBorder(comp, border);
        }
    }

    @Override
    public void managePortTabbedChild(IDockingPort port) {
        this.managePortSimpleChild(port);
        if (!(port.getDockedComponent() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)port.getDockedComponent();
        int tc = tabs.getTabCount();
        Component cmp = null;
        int i = 0;
        while (i < tc) {
            cmp = tabs.getComponentAt(i);
            if (cmp instanceof JComponent) {
                ((JComponent)cmp).setBorder(null);
            }
            ++i;
        }
    }

    private void setBorder(Component cmp, Border border) {
        if (cmp instanceof JComponent) {
            ((JComponent)cmp).setBorder(border);
        }
    }

    private void setBorder(IDockingPort port, Border border) {
        if (port instanceof JComponent) {
            ((JComponent)((Object)port)).setBorder(border);
        }
    }
}

