/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ActiveDockableTracker
implements PropertyChangeListener,
ChangeListener,
AWTEventListener {
    private static final String DOCKABLE_ACTIVATED = "dockableActivated";
    private static final ActiveDockableTracker INSTANCE = new ActiveDockableTracker();
    private WeakReference<IDockable> activeDockable;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    static {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusManager.addPropertyChangeListener(INSTANCE);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(INSTANCE, 16L);
    }

    private ActiveDockableTracker() {
        this.activeDockable = new WeakReference<Object>(null);
    }

    public static ActiveDockableTracker getInstance() {
        return INSTANCE;
    }

    public IDockable getActiveDockable() {
        return (IDockable)this.activeDockable.get();
    }

    public static void requestDockableActivation(Component c, boolean forceChange) {
        ActiveDockableTracker.requestDockableActivation(c, null, forceChange);
    }

    public static void requestDockableActivation(Component c, Component newFocusOwner, boolean forceChange) {
        IDockable dockable = DockingUtility.getAncestorDockable(c);
        if (dockable != null) {
            ActiveDockableTracker.requestDockableActivation(c, newFocusOwner, dockable, forceChange);
        }
    }

    private static void requestDockableActivation(final Component c, final Component newFocusOwner, final IDockable dockable, final boolean forceChange) {
        ActiveDockableTracker.activateWindow(c);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTabbedPane tabPane;
                int indx;
                if ((forceChange || !dockable.isActive()) && SyntheticaLookAndFeel.getBoolean((String)"JYDocking.focusFollowsDockable", (Component)dockable.getComponent(), (boolean)true)) {
                    ActiveDockableTracker.focusDockable(c, newFocusOwner, dockable);
                }
                JComponent parentComp = dockable.getComponent();
                if ((forceChange || !dockable.isActive()) && parentComp.getParent() instanceof JTabbedPane && (indx = (tabPane = (JTabbedPane)parentComp.getParent()).indexOfComponent(parentComp)) != tabPane.getSelectedIndex()) {
                    tabPane.setSelectedIndex(indx);
                }
                if (forceChange || !dockable.isActive()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!dockable.isActive()) {
                                INSTANCE.setActive(dockable, true);
                            }
                        }
                    });
                }
            }
        });
    }

    private static void activateWindow(Component c) {
        RootWindow window = RootWindow.getRootWindow(c);
        if (window != null && !window.isActive()) {
            window.toFront();
        }
    }

    private static void focusDockable(Component child, Component newFocusOwner, IDockable parentDockable) {
        JComponent parentComp = parentDockable.getComponent();
        Component focuser = newFocusOwner;
        if (focuser == null) {
            Container focusRoot = parentComp instanceof Container ? (Container)parentComp : null;
            Component component = focuser = focusRoot == null ? null : ActiveDockableTracker.getNearestFocusableComponent(child, focusRoot);
            if (focuser == null) {
                focuser = parentComp;
            }
        }
        focuser.requestFocus();
    }

    private static Component getNearestFocusableComponent(Component c, Container desiredRoot) {
        Container cnt;
        if (c == null) {
            c = desiredRoot;
        }
        if (c == null) {
            c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        boolean cachedFocusCycleRoot = false;
        if (desiredRoot != null && !(cachedFocusCycleRoot = desiredRoot.isFocusCycleRoot())) {
            desiredRoot.setFocusCycleRoot(true);
        }
        Container focusRoot = null;
        focusRoot = c instanceof Container ? ((cnt = (Container)c).isFocusCycleRoot(cnt) ? cnt : cnt.getFocusCycleRootAncestor()) : c.getFocusCycleRootAncestor();
        Component focuser = null;
        if (focusRoot != null) {
            focuser = c;
        }
        if (desiredRoot != null && !cachedFocusCycleRoot) {
            desiredRoot.setFocusCycleRoot(cachedFocusCycleRoot);
        }
        return focuser;
    }

    private void handleFocusChange(PropertyChangeEvent evt, Component oldVal, Component newVal, boolean activate) {
        if (!activate) {
            return;
        }
        if (newVal instanceof JTabbedPane) {
            newVal = ((JTabbedPane)newVal).getSelectedComponent();
        }
        this.activateComponent(newVal, true);
    }

    private void activateComponent(Component c, boolean activate) {
        IDockable dockable = DockingUtility.getAncestorDockable(c);
        if (dockable != null) {
            this.setActive(dockable, activate);
        }
    }

    private void setActive(IDockable dockable, boolean active) {
        IDockable oldValue = this.getActiveDockable();
        if (oldValue != null) {
            oldValue.setActive(!active);
        }
        this.activeDockable = new WeakReference<IDockable>(dockable);
        dockable.setActive(active);
        Perspective p = DockingManager.getPerspectiveManager().getCurrentPerspective();
        if (!p.isLoading()) {
            DockingState state;
            if (oldValue != null && (state = p.getDockingState(oldValue, false)) != null && p.getModel().contains(oldValue)) {
                state.setActive(!active);
            }
            if ((state = p.getDockingState(dockable, false)) != null) {
                state.setActive(active);
            }
        }
        this.changeSupport.firePropertyChange(DOCKABLE_ACTIVATED, oldValue, dockable);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Container container;
        if (event.getID() != 501 || !(event instanceof MouseEvent) || !(event.getSource() instanceof Component)) {
            return;
        }
        MouseEvent evt = (MouseEvent)event;
        Component c = (Component)evt.getSource();
        Container container2 = container = c instanceof Container ? (Container)c : null;
        if (container != null && container.getComponentCount() > 1) {
            Point p = evt.getPoint();
            c = SwingUtilities.getDeepestComponentAt(c, p.x, p.y);
        }
        ActiveDockableTracker.requestDockableActivation(c, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean activate;
        if (!(evt.getNewValue() instanceof Component)) {
            return;
        }
        String name = evt.getPropertyName();
        Component oldVal = (Component)evt.getOldValue();
        Component newVal = (Component)evt.getNewValue();
        boolean bl = activate = newVal != null;
        if ("activeWindow".equals(name)) {
            this.activateComponent(activate ? newVal : oldVal, activate);
        } else if ("permanentFocusOwner".equals(name)) {
            this.handleFocusChange(evt, oldVal, newVal, activate);
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object obj = evt.getSource();
        if (obj instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)obj;
            Component c = pane.getSelectedComponent();
            IDockable dockable = DockingManager.getDockable(c);
            Perspective p = PerspectiveManager.getInstance().getCurrentPerspective();
            if (dockable != null && !p.isUnloading()) {
                this.activateComponent(c, true);
            }
        }
    }
}

