/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking;

import de.javasoft.docking.JYDockingPort;
import de.javasoft.docking.controls.DockableComponentWrapper;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingStrategy;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableAcceptor;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.ui.DockingViewUI;
import de.javasoft.docking.ui.addons.JYDockingAddon;
import de.javasoft.docking.ui.controls.DockingButton;
import de.javasoft.docking.ui.controls.DockingViewContentPane;
import de.javasoft.docking.ui.controls.DockingViewTitlebar;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JYDockingView
extends JComponent
implements IDockable,
IDockingConstants {
    private static final long serialVersionUID = 1910286791529421496L;
    public static final String uiClassID = "JYDockingViewUI";
    protected DockingViewTitlebar titlebar;
    protected JPanel contentPane;
    protected Container userContentPane;
    private DockableComponentWrapper delegate;
    static final IDockingStrategy VIEW_DOCKING_STRATEGY;
    private boolean paintContentPaneBackground;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYDockingAddon());
        VIEW_DOCKING_STRATEGY = JYDockingView.createDockingStrategy();
        if (DockingManager.getDockingStrategy(JYDockingView.class) == null) {
            DockingManager.setDockingStrategy(JYDockingView.class, VIEW_DOCKING_STRATEGY);
        }
    }

    public JYDockingView(String id, String titleText, String tabText) {
        this.delegate = new DockableComponentWrapper(this, id, tabText, false);
        this.contentPane = new DockingViewContentPane();
        this.add(this.contentPane);
        this.setTitlebar(new DockingViewTitlebar());
        this.paintContentPaneBackground = true;
        this.setContentPane(this.createContentPane());
        super.setLayout(this.createLayout());
        this.setTitle(titleText == null ? "" : titleText);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                JYDockingView.this.clearButtonRollovers();
            }
        });
        this.updateUI();
        DockingManager.registerDockable(this);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewUI.class));
        DockingManager.isMaximized(this);
    }

    @Override
    public DockingViewUI getUI() {
        return (DockingViewUI)this.ui;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof DockingViewTitlebar) {
            ((DockingViewTitlebar)comp).setView(this);
            super.addImpl(comp, constraints, index);
        } else if (comp == this.contentPane) {
            super.addImpl(comp, constraints, index);
        } else {
            this.getContentPane().add(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        if (comp == this.userContentPane) {
            this.contentPane.remove(comp);
        } else {
            this.getContentPane().remove(comp);
        }
    }

    protected Container createContentPane() {
        return new JPanel();
    }

    protected LayoutManager createLayout() {
        return new ViewLayout();
    }

    public void setContentPane(Container c) throws IllegalArgumentException {
        if (this.userContentPane != null) {
            this.remove(this.userContentPane);
        }
        this.userContentPane = c;
        this.contentPane.add(this.userContentPane);
    }

    public Container getContentPane() {
        return this.userContentPane;
    }

    public void setTitle(String title) {
        if (this.titlebar != null) {
            this.titlebar.setTitleText(title);
        }
    }

    public String getTitle() {
        DockingViewTitlebar tbar = this.getTitlebar();
        return tbar == null ? null : tbar.getTitleText();
    }

    public void setDraggingEnabled(boolean enabled) {
        if (enabled) {
            this.getDragSources().add(this.getTitlebar());
            DockingManager.updateDragListeners(this);
        } else {
            this.getDragSources().remove(this.getTitlebar());
            DockingManager.removeDragListeners(this.getTitlebar());
        }
    }

    public boolean isDraggingEnabled() {
        return this.getDragSources().contains(this.getTitlebar());
    }

    public void setTitlebar(DockingViewTitlebar titlebar) {
        if (titlebar != null && titlebar == this.userContentPane) {
            throw new IllegalArgumentException("Cannot use the same component as both content pane and titlebar.");
        }
        if (this.titlebar != null) {
            this.remove(this.titlebar);
            this.titlebar.setView(null);
            this.getDragSources().remove(this.titlebar);
            DockingManager.removeDragListeners(this.titlebar);
        }
        this.titlebar = titlebar;
        if (titlebar != null) {
            this.add(titlebar);
            this.setDraggingEnabled(true);
        }
    }

    public DockingViewTitlebar getTitlebar() {
        return this.titlebar;
    }

    public void addAction(Action action) {
        if (this.titlebar != null) {
            this.titlebar.addAction(action);
        }
    }

    public void removeAction(Action action) {
        if (this.titlebar != null) {
            this.titlebar.removeAction(action);
        }
    }

    public void setIcon(Icon icon) {
        if (this.titlebar != null) {
            this.titlebar.setTitleIcon(icon);
        }
    }

    public Icon getIcon() {
        return this.titlebar == null ? null : this.titlebar.getTitleIcon();
    }

    @Override
    public void setLayout(LayoutManager manager) {
        this.getContentPane().setLayout(manager);
    }

    @Override
    protected String paramString() {
        return "id=" + this.getID() + "," + super.paramString();
    }

    private static IDockingStrategy createDockingStrategy() {
        return new DockingStrategy(){

            @Override
            protected IDockingPort createDockingPortImpl(IDockingPort base) {
                return new JYDockingPort();
            }
        };
    }

    private void clearButtonRollovers() {
        if (this.titlebar == null) {
            return;
        }
        Component[] comps = this.titlebar.getComponents();
        int i = 0;
        while (i < comps.length) {
            DockingButton button;
            DockingButton dockingButton = button = comps[i] instanceof DockingButton ? (DockingButton)comps[i] : null;
            if (button != null) {
                button.getModel().setRollover(false);
            }
            ++i;
        }
    }

    public boolean dock(IDockable dockable, String relativeRegion, float ratio) {
        return this.delegate.dock(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), relativeRegion, ratio);
    }

    @Override
    public JComponent getComponent() {
        return this.delegate.getComponent();
    }

    @Override
    public String getID() {
        return this.delegate.getID();
    }

    @Override
    public IDockingPort getDockingPort() {
        return this.delegate.getDockingPort();
    }

    @Override
    public List<JComponent> getDragSources() {
        return this.delegate.getDragSources();
    }

    @Override
    public boolean dock(IDockable dockable, Perspective perspective, String relativeRegion, float ratio) {
        return this.delegate.dock(dockable, perspective, relativeRegion, ratio);
    }

    @Override
    public void addDockingListener(IDockingEventListener listener) {
        this.delegate.addDockingListener(listener);
    }

    @Override
    public void removeDockingListener(IDockingEventListener listener) {
        this.delegate.removeDockingListener(listener);
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.delegate.getDockingListeners();
    }

    @Override
    public void setDockingEnabled(boolean enabled) {
        this.delegate.setDockingEnabled(enabled);
    }

    @Override
    public boolean isDockingEnabled() {
        return this.delegate.isDockingEnabled();
    }

    @Override
    public void setActive(boolean active) {
        this.delegate.setActive(active);
    }

    @Override
    public boolean isActive() {
        return this.delegate.isActive();
    }

    @Override
    public void setActiveStateLocked(boolean locked) {
        this.delegate.setActiveStateLocked(locked);
    }

    @Override
    public boolean isActiveStateLocked() {
        return this.delegate.isActiveStateLocked();
    }

    @Override
    public void setTabText(String text) {
        String oldValue = this.getTabText();
        this.delegate.setTabText(text);
        this.firePropertyChange("tabText", oldValue, text);
    }

    @Override
    public String getTabText() {
        return this.delegate.getTabText();
    }

    @Override
    public void setDockbarIcon(Icon icon) {
        Icon oldValue = this.getDockbarIcon();
        this.delegate.setDockbarIcon(icon);
        this.firePropertyChange("dockbarIcon", oldValue, icon);
    }

    @Override
    public Icon getDockbarIcon() {
        Icon icon = this.delegate.getDockbarIcon();
        return icon == null ? this.getIcon() : icon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        Icon oldValue = this.getTabIcon();
        this.delegate.setTabIcon(icon);
        this.firePropertyChange("tabIcon", oldValue, icon);
    }

    @Override
    public Icon getTabIcon() {
        Icon icon = this.delegate.getTabIcon();
        return icon == null ? this.getIcon() : icon;
    }

    @Override
    public void setRegionInset(String region, float inset) {
        this.delegate.setRegionInset(region, inset);
    }

    @Override
    public float getRegionInset(String region) {
        return this.delegate.getRegionInset(region);
    }

    @Override
    public void setSiblingSize(String region, float size) {
        this.delegate.setSiblingSize(region, size);
    }

    @Override
    public float getSiblingSize(String region) {
        return this.delegate.getSiblingSize(region);
    }

    @Override
    public void setTerritoryBlocked(String region, boolean blocked) {
        this.delegate.setTerritoryBlocked(region, blocked);
    }

    @Override
    public boolean isTerritoryBlocked(String region) {
        return this.delegate.isTerritoryBlocked(region);
    }

    @Override
    public void setDockableAcceptor(IDockableAcceptor acceptor) {
        IDockableAcceptor oldValue = this.getDockableAcceptor();
        this.delegate.setDockableAcceptor(acceptor);
        this.firePropertyChange("dockableAcceptor", oldValue, acceptor);
    }

    @Override
    public IDockableAcceptor getDockableAcceptor() {
        return this.delegate.getDockableAcceptor();
    }

    @Override
    public void setDragTheshold(float threshold) {
        this.delegate.setDragTheshold(threshold);
    }

    @Override
    public float getDragThreshold() {
        return this.delegate.getDragThreshold();
    }

    @Override
    public void setPreviewSize(float size) {
        this.delegate.setPreviewSize(size);
    }

    @Override
    public float getPreviewSize() {
        return this.delegate.getPreviewSize();
    }

    @Override
    public void setMouseMotionListenersBlockedWhileDragging(boolean blocked) {
        this.delegate.setMouseMotionListenersBlockedWhileDragging(blocked);
    }

    @Override
    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.delegate.isMouseMotionListenersBlockedWhileDragging();
    }

    public void setPaintContentPaneBackground(boolean paint) {
        this.paintContentPaneBackground = paint;
    }

    public boolean getPaintContentPaneBackground() {
        return this.paintContentPaneBackground;
    }

    @Override
    public void dockableRegistered(DockingEvent evt) {
        this.delegate.dockableRegistered(evt);
    }

    @Override
    public void dockableUnregistered(DockingEvent evt) {
        this.delegate.dockableUnregistered(evt);
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
        this.delegate.dockingCanceled(evt);
    }

    @Override
    public void dockingCompleted(DockingEvent evt) {
        this.delegate.dockingCompleted(evt);
        if (this.titlebar != null) {
            this.titlebar.revalidate();
        }
    }

    @Override
    public void dragStarted(DockingEvent evt) {
        this.delegate.dragStarted(evt);
    }

    @Override
    public void dropStarted(DockingEvent evt) {
        this.delegate.dropStarted(evt);
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
        this.delegate.undockingStarted(evt);
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
        this.delegate.undockingCompleted(evt);
        this.clearButtonRollovers();
    }

    protected class ViewLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = -785289772450064051L;

        protected ViewLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension rd = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getPreferredSize() : parent.getSize();
            Dimension tpd = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(rd.width, tpd.width) + insets.left + insets.right, rd.height + tpd.height + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension rd = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getMinimumSize() : parent.getSize();
            Dimension tpd = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getMinimumSize() : new Dimension(0, 0);
            Dimension dim = new Dimension(Math.max(rd.width, tpd.width) + insets.left + insets.right, rd.height + tpd.height + insets.top + insets.bottom);
            return dim;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            Insets insets = JYDockingView.this.getInsets();
            Dimension tpd = JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible() ? JYDockingView.this.titlebar.getMaximumSize() : new Dimension(0, 0);
            Dimension rd = JYDockingView.this.contentPane != null ? JYDockingView.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - insets.top - insets.bottom - tpd.height - 1);
            return new Dimension(Math.min(rd.width, tpd.width) + insets.left + insets.right, rd.height + tpd.height + insets.top + insets.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets insets = JYDockingView.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = b.width - insets.right - insets.left;
            int h = b.height - insets.top - insets.bottom;
            if (JYDockingView.this.titlebar != null && JYDockingView.this.titlebar.isVisible()) {
                Dimension dim = JYDockingView.this.titlebar.getPreferredSize();
                JYDockingView.this.titlebar.setBounds(0, 0, w, dim.height);
                h -= (y += dim.height);
            }
            if (JYDockingView.this.contentPane != null) {
                JYDockingView.this.contentPane.setBounds(x, y, w, h);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

