/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ThresholdList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swing.DefaultTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.LowerThresholdRangeModel;
import ca.odell.glazedlists.impl.swing.ManyToOneTableModelEventAdapterFactory;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.impl.swing.UpperThresholdRangeModel;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.DefaultEventComboBoxModel;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import javax.swing.BoundedRangeModel;

public final class GlazedListsSwing {
    private GlazedListsSwing() {
        throw new UnsupportedOperationException();
    }

    public static <E> TransformedList<E, E> swingThreadProxyList(EventList<E> source) {
        return new SwingThreadProxyEventList<E>(source);
    }

    public static boolean isSwingThreadProxyList(EventList list) {
        return list instanceof SwingThreadProxyEventList;
    }

    public static BoundedRangeModel lowerRangeModel(ThresholdList target) {
        return new LowerThresholdRangeModel(target);
    }

    public static BoundedRangeModel upperRangeModel(ThresholdList target) {
        return new UpperThresholdRangeModel(target);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        return new DefaultEventTableModel<E>(source, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source, TableFormat<? super E> tableFormat) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source);
        return new DefaultEventTableModel<E>(proxySource, true, tableFormat);
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> eventAdapterFactory) {
        DefaultEventTableModel<E> result = new DefaultEventTableModel<E>(source, tableFormat);
        TableModelEventAdapter<E> eventAdapter = eventAdapterFactory.create(result);
        result.setEventAdapter(eventAdapter);
        return result;
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source, TableFormat<? super E> tableFormat, TableModelEventAdapter.Factory<E> eventAdapterFactory) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source);
        DefaultEventTableModel<E> result = new DefaultEventTableModel<E>(proxySource, true, tableFormat);
        TableModelEventAdapter<E> eventAdapter = eventAdapterFactory.create(result);
        result.setEventAdapter(eventAdapter);
        return result;
    }

    public static <E> AdvancedTableModel<E> eventTableModel(EventList<E> source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        return GlazedListsSwing.eventTableModel(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public static <E> AdvancedTableModel<E> eventTableModelWithThreadProxyList(EventList<E> source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        return GlazedListsSwing.eventTableModelWithThreadProxyList(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    public static <E> TableModelEventAdapter.Factory<E> defaultEventAdapterFactory() {
        return DefaultTableModelEventAdapterFactory.getInstance();
    }

    public static <E> TableModelEventAdapter.Factory<E> manyToOneEventAdapterFactory() {
        return ManyToOneTableModelEventAdapterFactory.getInstance();
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModel(EventList<E> source) {
        return new DefaultEventSelectionModel<E>(source);
    }

    public static <E> AdvancedListSelectionModel<E> eventSelectionModelWithThreadProxyList(EventList<E> source) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source);
        return new DefaultEventSelectionModel<E>(proxySource, true);
    }

    public static <E> DefaultEventListModel<E> eventListModel(EventList<E> source) {
        return new DefaultEventListModel<E>(source);
    }

    public static <E> DefaultEventListModel<E> eventListModelWithThreadProxyList(EventList<E> source) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source);
        return new DefaultEventListModel<E>(proxySource, true);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModel(EventList<E> source) {
        return new DefaultEventComboBoxModel<E>(source);
    }

    public static <E> DefaultEventComboBoxModel<E> eventComboBoxModelWithThreadProxyList(EventList<E> source) {
        EventList<E> proxySource = GlazedListsSwing.createSwingThreadProxyList(source);
        return new DefaultEventComboBoxModel<E>(proxySource, true);
    }

    private static <E> EventList<E> createSwingThreadProxyList(EventList<E> source) {
        TransformedList<E, E> result;
        source.getReadWriteLock().readLock().lock();
        try {
            result = GlazedListsSwing.swingThreadProxyList(source);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
        return result;
    }
}

