/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SortingState {
    private static final Pattern FROM_STRING_PATTERN = Pattern.compile("^\\s*column\\s+(\\d+)(\\s+comparator\\s+(\\d+))?(\\s+(reversed))?\\s*$", 2);
    protected static final int COLUMN_UNSORTED = 0;
    protected static final int COLUMN_PRIMARY_SORTED = 1;
    protected static final int COLUMN_PRIMARY_SORTED_REVERSE = 2;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE = 3;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE_REVERSE = 4;
    protected static final int COLUMN_SECONDARY_SORTED = 5;
    protected static final int COLUMN_SECONDARY_SORTED_REVERSE = 6;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE = 7;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE_REVERSE = 8;
    protected List<SortingColumn> sortingColumns;
    protected List<SortingColumn> recentlyClickedColumns = new ArrayList<SortingColumn>(2);
    private final AbstractTableComparatorChooser tableComparatorChooser;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public SortingState(AbstractTableComparatorChooser tableComparatorChooser) {
        this.tableComparatorChooser = tableComparatorChooser;
    }

    public AbstractTableComparatorChooser getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void fireSortingChanged() {
        this.changeSupport.firePropertyChange("comparator", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Comparator buildComparator() {
        if (this.recentlyClickedColumns.isEmpty()) {
            return null;
        }
        ArrayList comparators = new ArrayList(this.recentlyClickedColumns.size());
        for (SortingColumn sortingColumn : this.recentlyClickedColumns) {
            Comparator comparator = sortingColumn.getComparator();
            if (comparator == null) {
                throw new IllegalStateException();
            }
            comparators.add(comparator);
        }
        return GlazedLists.chainComparators(comparators);
    }

    public List<Integer> getSortingColumnIndexes() {
        ArrayList<Integer> sortingColumns = new ArrayList<Integer>();
        List<SortingColumn> recentlyClickedColumns = this.getRecentlyClickedColumns();
        int c = 0;
        while (c < recentlyClickedColumns.size()) {
            SortingColumn clickedColumn = recentlyClickedColumns.get(c);
            sortingColumns.add(new Integer(clickedColumn.getColumn()));
            ++c;
        }
        return sortingColumns;
    }

    public void appendComparator(int column, int comparatorIndex, boolean reverse) {
        if (column > this.getColumns().size()) {
            throw new IllegalArgumentException("invalid column " + column + ", must be in range 0, " + this.sortingColumns.size());
        }
        if (comparatorIndex >= this.sortingColumns.get(column).getComparators().size()) {
            throw new IllegalArgumentException("invalid comparator index " + comparatorIndex + ", must be in range 0, " + this.sortingColumns.get(column).getComparators().size());
        }
        if (this.recentlyClickedColumns.contains(this.getColumns().get(column))) {
            return;
        }
        SortingColumn sortingColumn = this.sortingColumns.get(column);
        sortingColumn.setComparatorIndex(comparatorIndex);
        sortingColumn.setReverse(reverse);
        this.recentlyClickedColumns.add(sortingColumn);
    }

    public void detectStateFromComparator(Comparator foreignComparator) {
        List<Object> comparatorsList;
        this.clearComparators();
        if (foreignComparator == null) {
            comparatorsList = Collections.emptyList();
        } else if (foreignComparator instanceof ComparatorChain) {
            ComparatorChain chain = (ComparatorChain)foreignComparator;
            comparatorsList = Arrays.asList(chain.getComparators());
        } else {
            comparatorsList = Collections.singletonList(foreignComparator);
        }
        for (Comparator comparator : comparatorsList) {
            boolean reverse = false;
            if (comparator instanceof ReverseComparator) {
                reverse = true;
                comparator = ((ReverseComparator)comparator).getSourceComparator();
            }
            int c = 0;
            while (c < this.sortingColumns.size()) {
                int comparatorIndex;
                if (!this.recentlyClickedColumns.contains(this.sortingColumns.get(c)) && (comparatorIndex = this.sortingColumns.get(c).getComparators().indexOf(comparator)) != -1) {
                    SortingColumn columnClickTracker = this.sortingColumns.get(c);
                    columnClickTracker.setComparatorIndex(comparatorIndex);
                    columnClickTracker.setReverse(reverse);
                    this.recentlyClickedColumns.add(columnClickTracker);
                }
                ++c;
            }
        }
    }

    public void clearComparators() {
        for (SortingColumn sortingColumn : this.recentlyClickedColumns) {
            sortingColumn.clear();
        }
        this.recentlyClickedColumns.clear();
    }

    public void rebuildColumns(TableFormat tableFormat) {
        int columnCount = tableFormat.getColumnCount();
        this.sortingColumns = new ArrayList<SortingColumn>(columnCount);
        int i = 0;
        while (i < columnCount) {
            this.sortingColumns.add(this.createSortingColumn(tableFormat, i));
            ++i;
        }
        this.recentlyClickedColumns.clear();
    }

    protected SortingColumn createSortingColumn(TableFormat tableFormat, int columnIndex) {
        return new SortingColumn(tableFormat, columnIndex);
    }

    public List<SortingColumn> getColumns() {
        return this.sortingColumns;
    }

    public List<SortingColumn> getRecentlyClickedColumns() {
        return this.recentlyClickedColumns;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator<Integer> i = this.getSortingColumnIndexes().iterator();
        while (i.hasNext()) {
            int columnIndex = i.next();
            SortingColumn sortingColumn = this.getColumns().get(columnIndex);
            result.append("column ");
            result.append(columnIndex);
            int comparatorIndex = sortingColumn.getComparatorIndex();
            if (comparatorIndex != 0) {
                result.append(" comparator ");
                result.append(comparatorIndex);
            }
            if (sortingColumn.isReverse()) {
                result.append(" reversed");
            }
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public void fromString(String stringEncoded) {
        this.clearComparators();
        String[] parts = stringEncoded.split(",");
        int p = 0;
        while (p < parts.length) {
            if (parts[p].trim().length() != 0) {
                boolean reversedComparator;
                Matcher matcher = FROM_STRING_PATTERN.matcher(parts[p]);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Failed to parse column spec, \"" + parts[p] + "\"");
                }
                int columnIndex = Integer.parseInt(matcher.group(1));
                int comparatorIndex = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
                boolean bl = reversedComparator = matcher.group(5) != null;
                if (columnIndex < this.sortingColumns.size() && comparatorIndex < this.sortingColumns.get(columnIndex).getComparators().size()) {
                    this.appendComparator(columnIndex, comparatorIndex, reversedComparator);
                }
            }
            ++p;
        }
    }

    public class SortingColumn {
        private final int column;
        private final List<Comparator> comparators = new ArrayList<Comparator>(1);
        private boolean reverse = false;
        private int comparatorIndex = -1;

        public SortingColumn(TableFormat tableFormat, int column) {
            this.column = column;
            if (tableFormat instanceof AdvancedTableFormat) {
                AdvancedTableFormat advancedTableFormat = (AdvancedTableFormat)tableFormat;
                Comparator columnComparator = advancedTableFormat.getColumnComparator(column);
                if (columnComparator != null) {
                    this.comparators.add(new TableColumnComparator(tableFormat, column, columnComparator));
                }
            } else {
                this.comparators.add(new TableColumnComparator(tableFormat, column));
            }
        }

        public void clear() {
            this.reverse = false;
            this.comparatorIndex = -1;
        }

        public int getColumn() {
            return this.column;
        }

        public void setComparatorIndex(int comparatorIndex) {
            assert (comparatorIndex < this.comparators.size());
            this.comparatorIndex = comparatorIndex;
        }

        public int getComparatorIndex() {
            return this.comparatorIndex;
        }

        public List<Comparator> getComparators() {
            return this.comparators;
        }

        public Comparator getComparator() {
            if (this.comparatorIndex == -1) {
                return null;
            }
            Comparator comparator = this.comparators.get(this.getComparatorIndex());
            if (this.isReverse()) {
                comparator = GlazedLists.reverseComparator(comparator);
            }
            return comparator;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setReverse(boolean reverse) {
            this.reverse = reverse;
        }

        public int getSortingStyle() {
            boolean primaryComparator;
            if (this.comparatorIndex == -1) {
                return 0;
            }
            boolean primaryColumn = !SortingState.this.recentlyClickedColumns.isEmpty() && SortingState.this.recentlyClickedColumns.get(0) == this;
            boolean bl = primaryComparator = this.getComparatorIndex() == 0;
            if (primaryColumn) {
                if (!this.isReverse()) {
                    if (primaryComparator) {
                        return 1;
                    }
                    return 3;
                }
                if (primaryComparator) {
                    return 2;
                }
                return 4;
            }
            if (!this.isReverse()) {
                if (primaryComparator) {
                    return 5;
                }
                return 7;
            }
            if (primaryComparator) {
                return 6;
            }
            return 8;
        }
    }
}

