/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterable;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.matchers.SearchEngineTextMatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class TextMatchers {
    private static final Comparator<SearchTerm> SEARCHTERM_LENGTH_COMPARATOR = new SearchTermLengthComparator();
    private static final Matcher<SearchTerm> NON_NEGATED_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", Boolean.FALSE);
    private static final Matcher<SearchTerm> NEGATED_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", Boolean.TRUE);
    private static final Matcher<SearchTerm> NO_FIELD_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", null);
    private static final Matcher<SearchTerm> FIELD_MATCHER = Matchers.invert(NO_FIELD_MATCHER);

    public static <E> boolean matches(List<String> filterStrings, TextFilterator<? super E> filterator, SearchTerm<E>[] searchTerms, TextSearchStrategy[] filterStrategies, E element) {
        boolean filterStringsPopulated = false;
        int f = 0;
        while (f < filterStrategies.length) {
            block12: {
                String filterString;
                int n;
                int i;
                List<String> strings;
                TextSearchStrategy textSearchStrategy = filterStrategies[f];
                SearchTerm<E> searchTerm = searchTerms[f];
                SearchEngineTextMatcherEditor.Field<E> searchTermField = searchTerm.getField();
                if (searchTermField != null) {
                    strings = searchTerm.getFieldFilterStrings();
                    strings.clear();
                    searchTermField.getTextFilterator().getFilterStrings(strings, element);
                } else {
                    if (!filterStringsPopulated) {
                        filterStrings.clear();
                        if (filterator == null) {
                            ((TextFilterable)element).getFilterStrings(filterStrings);
                        } else {
                            filterator.getFilterStrings(filterStrings, element);
                        }
                        filterStringsPopulated = true;
                    }
                    strings = filterStrings;
                }
                if (searchTerm.isNegated()) {
                    i = 0;
                    n = strings.size();
                    while (i < n) {
                        filterString = strings.get(i);
                        if (filterString != null && textSearchStrategy.indexOf(filterString.toString()) != -1) {
                            return false;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    n = strings.size();
                    while (i < n) {
                        filterString = strings.get(i);
                        if (filterString == null || textSearchStrategy.indexOf(filterString.toString()) == -1) {
                            ++i;
                            continue;
                        }
                        break block12;
                    }
                    return false;
                }
            }
            ++f;
        }
        return true;
    }

    private static List<SearchTerm> normalizeSearchTerms(List<SearchTerm> searchTerms, boolean negated) {
        ArrayList<SearchTerm> result = new ArrayList<SearchTerm>(searchTerms);
        Iterator i = result.iterator();
        while (i.hasNext()) {
            SearchTerm searchTerm = (SearchTerm)i.next();
            if (searchTerm != null && searchTerm.getText().length() != 0) continue;
            i.remove();
        }
        int i2 = 0;
        while (i2 < result.size()) {
            SearchTerm termI = (SearchTerm)result.get(i2);
            int j = 0;
            while (j < result.size()) {
                SearchTerm termJ = (SearchTerm)result.get(j);
                if (i2 != j && termJ.getText().indexOf(termI.getText()) != -1) {
                    if (negated) {
                        if (!termJ.isRequired()) {
                            result.remove(j);
                        }
                    } else if (!termI.isRequired()) {
                        result.remove(i2);
                        break;
                    }
                }
                ++j;
            }
            ++i2;
        }
        Collections.sort(result, negated ? GlazedLists.reverseComparator(SEARCHTERM_LENGTH_COMPARATOR) : SEARCHTERM_LENGTH_COMPARATOR);
        return result;
    }

    public static SearchTerm[] normalizeSearchTerms(SearchTerm[] filters, TextSearchStrategy.Factory strategy) {
        if (strategy == TextMatcherEditor.NORMALIZED_STRATEGY) {
            char[] mapper = GlazedListsImpl.getLatinDiacriticsStripper();
            SearchTerm[] mappedFilters = new SearchTerm[filters.length];
            int i = 0;
            while (i < filters.length) {
                String filter = filters[i].getText();
                char[] mappedFilter = new char[filter.length()];
                int j = 0;
                while (j < filter.length()) {
                    char c = filter.charAt(j);
                    mappedFilter[j] = c < mapper.length ? mapper[c] : c;
                    ++j;
                }
                mappedFilters[i] = filters[i].newSearchTerm(new String(mappedFilter));
                ++i;
            }
            filters = mappedFilters;
        }
        SearchTerm[] nonNullFieldSearchTerms = Matchers.select(filters, NO_FIELD_MATCHER);
        SearchTerm[] nullFieldSearchTerms = Matchers.select(filters, FIELD_MATCHER);
        List<SearchTerm> negatedUnrequiredSearchTerms = Arrays.asList(Matchers.select(nullFieldSearchTerms, NEGATED_MATCHER));
        List<SearchTerm> nonNegatedUnrequiredSearchTerms = Arrays.asList(Matchers.select(nullFieldSearchTerms, NON_NEGATED_MATCHER));
        ArrayList<SearchTerm> allSearchTerms = new ArrayList<SearchTerm>(filters.length);
        allSearchTerms.addAll(Arrays.asList(nonNullFieldSearchTerms));
        allSearchTerms.addAll(TextMatchers.normalizeSearchTerms(negatedUnrequiredSearchTerms, true));
        allSearchTerms.addAll(TextMatchers.normalizeSearchTerms(nonNegatedUnrequiredSearchTerms, false));
        return allSearchTerms.toArray(new SearchTerm[allSearchTerms.size()]);
    }

    public static <E> SearchTerm<E>[] parse(String text) {
        return TextMatchers.parse(text, Collections.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SearchTerm<E>[] parse(String text, Set<SearchEngineTextMatcherEditor.Field<E>> fields) {
        void var5_7;
        ArrayList searchTerms = new ArrayList();
        HashMap<String, SearchEngineTextMatcherEditor.Field<E>> fieldMap = new HashMap<String, SearchEngineTextMatcherEditor.Field<E>>();
        for (SearchEngineTextMatcherEditor.Field<E> field : fields) {
            fieldMap.put(field.getName(), field);
        }
        StringBuffer searchTermText = new StringBuffer();
        Object var5_6 = null;
        boolean negated = false;
        boolean required = false;
        boolean insideTerm = false;
        boolean insideQuotedTerm = false;
        int i = 0;
        int n = text.length();
        while (i < n) {
            char c = text.charAt(i);
            if (insideTerm) {
                SearchEngineTextMatcherEditor.Field field;
                boolean endOfTerm;
                boolean bl = endOfTerm = c == '\"' || !insideQuotedTerm && Character.isWhitespace(c);
                if (endOfTerm) {
                    if (searchTermText.length() > 0) {
                        searchTerms.add(new SearchTerm(searchTermText.toString(), negated, required, var5_7));
                    }
                    searchTermText = new StringBuffer();
                    Object var5_8 = null;
                    insideQuotedTerm = false;
                    insideTerm = false;
                    required = false;
                    negated = false;
                } else if (c == ':' && var5_7 == null && !insideQuotedTerm && (field = (SearchEngineTextMatcherEditor.Field)fieldMap.get(searchTermText.toString())) != null) {
                    searchTermText = new StringBuffer();
                    insideQuotedTerm = false;
                    insideTerm = false;
                    required = false;
                    negated = false;
                } else {
                    searchTermText.append(c);
                }
            } else if (Character.isWhitespace(c)) {
                Object var5_10 = null;
                insideQuotedTerm = false;
                insideTerm = false;
                required = false;
                negated = false;
            } else {
                switch (c) {
                    case '\"': {
                        insideTerm = true;
                        insideQuotedTerm = true;
                        break;
                    }
                    case '+': {
                        required = true;
                        break;
                    }
                    case '-': {
                        negated = true;
                        break;
                    }
                    default: {
                        searchTermText.append(c);
                        insideTerm = true;
                    }
                }
            }
            ++i;
        }
        if (searchTermText.length() > 0) {
            searchTerms.add(new SearchTerm(searchTermText.toString(), negated, required, var5_7));
        }
        return searchTerms.toArray(new SearchTerm[searchTerms.size()]);
    }

    public static boolean isMatcherConstrained(TextMatcher oldMatcher, TextMatcher newMatcher) {
        if (oldMatcher.equals(newMatcher)) {
            return false;
        }
        if (oldMatcher.getStrategy() != newMatcher.getStrategy()) {
            return false;
        }
        if (oldMatcher.getMode() == 1 && newMatcher.getMode() == 0) {
            return false;
        }
        if (oldMatcher.getMode() == 2 || newMatcher.getMode() == 2) {
            return false;
        }
        if (oldMatcher.getMode() == 3 || newMatcher.getMode() == 3) {
            return false;
        }
        SearchTerm[] oldTerms = oldMatcher.getSearchTerms();
        SearchTerm[] newTerms = newMatcher.getSearchTerms();
        int i = 0;
        while (i < oldTerms.length) {
            block8: {
                int j = 0;
                while (j < newTerms.length) {
                    if (!newTerms[j].equals(oldTerms[i]) && !newTerms[j].isConstrainment(oldTerms[i])) {
                        ++j;
                        continue;
                    }
                    break block8;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMatcherRelaxed(TextMatcher oldMatcher, TextMatcher newMatcher) {
        return TextMatchers.isMatcherConstrained(newMatcher, oldMatcher);
    }

    private static final class SearchTermLengthComparator
    implements Comparator<SearchTerm> {
        private SearchTermLengthComparator() {
        }

        @Override
        public int compare(SearchTerm a, SearchTerm b) {
            return b.getText().length() - a.getText().length();
        }
    }
}

