/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;

public class StartsWithCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private IndexOfStrategy indexOfStrategy;

    @Override
    public void setSubtext(String subtext) {
        this.indexOfStrategy = subtext.length() == 1 ? new SingleCharacterIndexOfStrategy(subtext.charAt(0)) : new MultiCharacterIndexOfStrategy(subtext);
    }

    @Override
    public int indexOf(String text) {
        if (this.indexOfStrategy == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        return this.indexOfStrategy.indexOf(text);
    }

    private static interface IndexOfStrategy {
        public int indexOf(String var1);
    }

    private class MultiCharacterIndexOfStrategy
    implements IndexOfStrategy {
        private final int subtextLength;
        private char[] subtextCharsUpper;
        private char[] subtextCharsLower;

        public MultiCharacterIndexOfStrategy(String prefix) {
            this.subtextLength = prefix.length();
            this.subtextCharsUpper = prefix.toUpperCase().toCharArray();
            this.subtextCharsLower = prefix.toLowerCase().toCharArray();
        }

        @Override
        public int indexOf(String text) {
            if (text.length() < this.subtextLength) {
                return -1;
            }
            int i = 0;
            while (i < this.subtextLength) {
                char c = StartsWithCaseInsensitiveTextSearchStrategy.this.map(text.charAt(i));
                if (this.subtextCharsLower[i] != c && this.subtextCharsUpper[i] != c) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
    }

    private class SingleCharacterIndexOfStrategy
    implements IndexOfStrategy {
        private final char upperCase;
        private final char lowerCase;

        public SingleCharacterIndexOfStrategy(char c) {
            this.upperCase = Character.toUpperCase(c);
            this.lowerCase = Character.toLowerCase(c);
        }

        @Override
        public int indexOf(String text) {
            if (text.length() < 1) {
                return -1;
            }
            char c = StartsWithCaseInsensitiveTextSearchStrategy.this.map(text.charAt(0));
            return c == this.upperCase || c == this.lowerCase ? 0 : -1;
        }
    }
}

