/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;
import java.util.Arrays;

public class BoyerMooreCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private static final int CHARACTER_CACHE_SIZE = 256;
    private int subtextLength;
    private int lastSubtextIndex;
    private char[] subtextCharsUpper;
    private char[] subtextCharsLower;
    private int[] shiftTable = new int[256];

    @Override
    public void setSubtext(String subtext) {
        this.subtextLength = subtext.length();
        this.lastSubtextIndex = this.subtextLength - 1;
        this.subtextCharsUpper = subtext.toUpperCase().toCharArray();
        this.subtextCharsLower = subtext.toLowerCase().toCharArray();
        Arrays.fill(this.shiftTable, 0, this.shiftTable.length, this.subtextLength);
        int i = 0;
        while (i < this.lastSubtextIndex) {
            this.shiftTable[this.subtextCharsUpper[i] % 256] = this.lastSubtextIndex - i;
            if (this.subtextCharsUpper[i] != this.subtextCharsLower[i]) {
                this.shiftTable[this.subtextCharsLower[i] % 256] = this.lastSubtextIndex - i;
            }
            ++i;
        }
    }

    @Override
    public int indexOf(String text) {
        if (this.subtextCharsUpper == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        int textPosition = this.lastSubtextIndex;
        char textChar = ' ';
        int textLength = text.length();
        while (textPosition < textLength) {
            int subtextPosition = this.lastSubtextIndex;
            if (subtextPosition >= 0) {
                textChar = this.map(text.charAt(textPosition));
                while (subtextPosition >= 0 && (this.subtextCharsLower[subtextPosition] == textChar || this.subtextCharsUpper[subtextPosition] == textChar)) {
                    if (--textPosition != -1) {
                        textChar = this.map(text.charAt(textPosition));
                    }
                    --subtextPosition;
                }
            }
            if (subtextPosition == -1) {
                return textPosition + 1;
            }
            textPosition += Math.max(this.shiftTable[textChar % 256], this.subtextLength - subtextPosition);
        }
        return -1;
    }
}

