/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.ctp;

import ca.odell.glazedlists.impl.ctp.CTPConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

class CloseConnection
implements Runnable {
    private static Logger logger = Logger.getLogger(CloseConnection.class.toString());
    private CTPConnection connection;
    private Exception reason;

    public CloseConnection(CTPConnection connection, Exception reason) {
        this.connection = connection;
        this.reason = reason;
    }

    @Override
    public void run() {
        if (this.connection.state == 8) {
            return;
        }
        if (this.reason == null || !(this.reason instanceof IOException)) {
            if (this.connection.state == 3) {
                this.connection.state = 4;
                this.connection.sendResponse(500, Collections.EMPTY_MAP);
            } else if (this.connection.state == 6) {
                this.connection.sendChunk(null);
            }
        }
        try {
            this.connection.writer.writeToChannel(this.connection.socketChannel, this.connection.selectionKey);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.connection.writer.length() > 0) {
            logger.warning("Close proceeding with unsent data");
        }
        try {
            this.connection.socketChannel.close();
            this.connection.selectionKey.cancel();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.reason != null) {
            logger.log(Level.WARNING, "Closed connection to " + this.connection + " due to " + this.reason, this.reason);
        } else {
            logger.info("Closed connection to " + this.connection);
        }
        this.connection.state = 8;
        this.connection.handler.connectionClosed(this.connection, this.reason);
    }
}

