/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.beans.BeanProperty;
import java.util.List;

public class BeanTextFilterator<D, E>
implements TextFilterator<E>,
Filterator<D, E> {
    private String[] propertyNames;
    private BeanProperty[] beanProperties = null;

    public BeanTextFilterator(String ... propertyNames) {
        this.propertyNames = propertyNames;
    }

    public BeanTextFilterator(Class<E> beanClass, String ... propertyNames) {
        this.propertyNames = propertyNames;
        this.loadPropertyDescriptors(beanClass);
    }

    @Override
    public void getFilterStrings(List<String> baseList, E element) {
        if (element == null) {
            return;
        }
        if (this.beanProperties == null) {
            this.loadPropertyDescriptors(element.getClass());
        }
        int p = 0;
        while (p < this.beanProperties.length) {
            Object propertyValue = this.beanProperties[p].get(element);
            if (propertyValue != null) {
                baseList.add(propertyValue.toString());
            }
            ++p;
        }
    }

    @Override
    public void getFilterValues(List<D> baseList, E element) {
        if (element == null) {
            return;
        }
        if (this.beanProperties == null) {
            this.loadPropertyDescriptors(element.getClass());
        }
        int p = 0;
        while (p < this.beanProperties.length) {
            Object propertyValue = this.beanProperties[p].get(element);
            if (propertyValue != null) {
                baseList.add(propertyValue);
            }
            ++p;
        }
    }

    private void loadPropertyDescriptors(Class beanClass) {
        this.beanProperties = new BeanProperty[this.propertyNames.length];
        int p = 0;
        while (p < this.propertyNames.length) {
            this.beanProperties[p] = new BeanProperty(beanClass, this.propertyNames[p], true, false);
            ++p;
        }
    }
}

