/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.ObservableElementChangeHandler;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;

public class BeanConnector<E>
implements ObservableElementList.Connector<E> {
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private ObservableElementChangeHandler<? extends E> list;
    protected PropertyChangeListener propertyChangeListener = this.createPropertyChangeListener();
    private Matcher<PropertyChangeEvent> eventMatcher = Matchers.trueMatcher();
    private final Object[] reflectionParameters = new Object[]{this.propertyChangeListener};
    private static final Class[] REFLECTION_TYPES = new Class[]{PropertyChangeListener.class};

    public BeanConnector(Class<E> beanClass) {
        Method[] methods = beanClass.getMethods();
        int m = 0;
        while (m < methods.length) {
            if (methods[m].getParameterTypes().length == 1 && methods[m].getParameterTypes()[0] == PropertyChangeListener.class) {
                if (methods[m].getName().startsWith("add")) {
                    this.addListenerMethod = methods[m];
                }
                if (methods[m].getName().startsWith("remove")) {
                    this.removeListenerMethod = methods[m];
                }
            }
            ++m;
        }
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IllegalArgumentException("Couldn't find listener methods for " + beanClass.getName());
        }
    }

    public BeanConnector(Class<E> beanClass, Matcher<PropertyChangeEvent> eventMatcher) {
        this(beanClass);
        super.setEventMatcher(eventMatcher);
    }

    public BeanConnector(Class<E> beanClass, String addListenerMethodName, String removeListenerMethodName) {
        try {
            this.addListenerMethod = beanClass.getMethod(addListenerMethodName, REFLECTION_TYPES);
            this.removeListenerMethod = beanClass.getMethod(removeListenerMethodName, REFLECTION_TYPES);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to find method " + e.getMessage() + " in " + beanClass);
        }
    }

    public BeanConnector(Class<E> beanClass, String addListenerMethodName, String removeListenerMethodName, Matcher<PropertyChangeEvent> eventMatcher) {
        this(beanClass, addListenerMethodName, removeListenerMethodName);
        super.setEventMatcher(eventMatcher);
    }

    @Override
    public EventListener installListener(E element) {
        try {
            this.addListenerMethod.invoke(element, this.reflectionParameters);
            return this.propertyChangeListener;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(ite.getCause());
        }
    }

    @Override
    public void uninstallListener(E element, EventListener listener) {
        try {
            this.removeListenerMethod.invoke(element, this.reflectionParameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void setObservableElementList(ObservableElementChangeHandler<? extends E> list) {
        this.list = list;
    }

    public final Matcher<PropertyChangeEvent> getEventMatcher() {
        return this.eventMatcher;
    }

    private void setEventMatcher(Matcher<PropertyChangeEvent> eventMatcher) {
        if (eventMatcher == null) {
            throw new IllegalArgumentException("Event matcher may not be null.");
        }
        this.eventMatcher = eventMatcher;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ObservableElementChangeHandler handler = BeanConnector.this.list;
            if (handler != null && BeanConnector.this.getEventMatcher().matches(event)) {
                handler.elementChanged(event.getSource());
            }
        }
    }
}

