/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.WeakReferenceProxy;

public final class SubEventList<E>
extends TransformedList<E, E> {
    private int startIndex;
    private int endIndex;

    public SubEventList(EventList<E> source, int startIndex, int endIndex, boolean automaticallyRemove) {
        super(source);
        if (startIndex < 0 || endIndex < startIndex || endIndex > source.size()) {
            throw new IllegalArgumentException("The range " + startIndex + "-" + endIndex + " is not valid over a list of size " + source.size());
        }
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        if (automaticallyRemove) {
            source.addListEventListener(new WeakReferenceProxy<E>(source, this));
        } else {
            source.addListEventListener(this);
        }
    }

    @Override
    public int size() {
        return this.endIndex - this.startIndex;
    }

    @Override
    protected int getSourceIndex(int mutationIndex) {
        return mutationIndex + this.startIndex;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void listChanged(ListEvent<E> listChanges) {
        block8: {
            this.updates.beginEvent();
            if (!listChanges.isReordering() || this.size() != 1) ** GOTO lbl35
            reorderMap = listChanges.getReorderMap();
            r = 0;
            while (r < reorderMap.length) {
                if (reorderMap[r] == this.startIndex) {
                    this.startIndex = r;
                    this.endIndex = this.startIndex + 1;
                    break block8;
                }
                ++r;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                changeIndex = listChanges.getIndex();
                changeType = listChanges.getType();
                if (changeIndex < this.startIndex || changeType == 2 && changeIndex == this.startIndex) {
                    if (changeType == 2) {
                        ++this.startIndex;
                        ++this.endIndex;
                        continue;
                    }
                    if (changeType != 0) continue;
                    --this.startIndex;
                    --this.endIndex;
                    continue;
                }
                if (changeIndex >= this.endIndex) continue;
                if (changeType == 2) {
                    ++this.endIndex;
                    this.updates.elementInserted(changeIndex - this.startIndex, listChanges.getNewValue());
                    continue;
                }
                if (changeType == 1) {
                    this.updates.elementUpdated(changeIndex - this.startIndex, listChanges.getOldValue(), listChanges.getNewValue());
                    continue;
                }
                if (changeType != 0) continue;
                --this.endIndex;
                this.updates.elementDeleted(changeIndex - this.startIndex, listChanges.getOldValue());
lbl35:
                // 9 sources

                ** while (listChanges.next())
            }
        }
        if (this.startIndex > this.endIndex) {
            throw new IllegalStateException();
        }
        this.updates.commitEvent();
    }
}

