/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SeparatorList<E>
extends TransformedList<E, E> {
    private SeparatorInjectorList<E> separatorSource;
    private static final Object SEPARATOR = Barcode.BLACK;
    private static final Object SOURCE_ELEMENT = Barcode.WHITE;
    private final int minimumSizeForSeparator;
    private Barcode collapsedElements;

    public SeparatorList(EventList<E> source, Comparator<? super E> comparator, int minimumSizeForSeparator, int defaultLimit) {
        super(new SeparatorInjectorList<E>(new SortedList<E>(source, comparator), defaultLimit));
        this.separatorSource = (SeparatorInjectorList)this.source;
        this.minimumSizeForSeparator = minimumSizeForSeparator;
        this.rebuildCollapsedElements();
        this.separatorSource.addListEventListener(this);
    }

    private void rebuildCollapsedElements() {
        this.collapsedElements = new Barcode();
        this.collapsedElements.addBlack(0, this.separatorSource.size());
        int groupCount = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.colourSize(SEPARATOR);
        int i = 0;
        while (i < groupCount) {
            this.updateGroup(i, groupCount, false);
            ++i;
        }
    }

    @Override
    public int size() {
        return this.collapsedElements.colourSize(Barcode.BLACK);
    }

    @Override
    protected int getSourceIndex(int mutationIndex) {
        return this.collapsedElements.getIndex(mutationIndex, Barcode.BLACK);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    public void setComparator(Comparator<E> comparator) {
        boolean isEmpty = this.isEmpty();
        if (!isEmpty) {
            this.updates.beginEvent();
            this.updates.addDelete(0, this.size() - 1);
        }
        SortedList sortedList = (SortedList)this.separatorSource.source;
        sortedList.setComparator(comparator);
        if (!isEmpty) {
            this.rebuildCollapsedElements();
            this.updates.addInsert(0, this.size() - 1);
            this.updates.commitEvent();
        } else {
            ((SeparatorInjectorList)this.separatorSource).grouper.setComparator(comparator);
        }
    }

    private static boolean nextBlackGroup(BarcodeIterator iterator) {
        if (!iterator.hasNextWhite()) {
            return false;
        }
        iterator.nextWhite();
        if (!iterator.hasNextBlack()) {
            return false;
        }
        iterator.nextBlack();
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        block15: {
            int changeType;
            int changeIndex;
            block13: {
                block14: {
                    this.updates.beginEvent(true);
                    if (!listChanges.isReordering()) break block13;
                    boolean canReorder = true;
                    SimpleTreeIterator i = new SimpleTreeIterator(((SeparatorInjectorList)this.separatorSource).separators);
                    while (i.hasNext()) {
                        i.next();
                        Element node = i.node();
                        int limit = ((SeparatorInjectorList.GroupSeparator)node.get()).getLimit();
                        if (limit == 0 || limit >= this.separatorSource.size() || limit >= ((SeparatorInjectorList.GroupSeparator)node.get()).size()) continue;
                        canReorder = false;
                        break;
                    }
                    if (!canReorder) break block14;
                    int[] previousIndices = listChanges.getReorderMap();
                    int[] reorderMap = new int[this.collapsedElements.colourSize(Barcode.BLACK)];
                    BarcodeIterator i2 = this.collapsedElements.iterator();
                    int groupStartSourceIndex = 0;
                    while (true) {
                        int leadingCollapsedElements;
                        boolean newGroupFound;
                        int groupEndSourceIndex;
                        if (i2.hasNextWhite()) {
                            i2.nextWhite();
                            groupEndSourceIndex = i2.getIndex();
                            newGroupFound = true;
                            leadingCollapsedElements = i2.getWhiteIndex();
                        } else {
                            newGroupFound = false;
                            groupEndSourceIndex = this.collapsedElements.size();
                            leadingCollapsedElements = this.collapsedElements.whiteSize();
                        }
                        int j = groupStartSourceIndex;
                        while (j < groupEndSourceIndex) {
                            reorderMap[j - leadingCollapsedElements] = previousIndices[j] - leadingCollapsedElements;
                            ++j;
                        }
                        if (!newGroupFound || !i2.hasNextBlack()) break;
                        i2.nextBlack();
                        groupStartSourceIndex = i2.getIndex();
                    }
                    this.updates.reorder(reorderMap);
                    break block15;
                }
                int size = this.collapsedElements.colourSize(Barcode.BLACK);
                if (size <= 0) break block15;
                this.updates.addDelete(0, size - 1);
                this.updates.addInsert(0, size - 1);
                break block15;
            }
            int groupCount = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.colourSize(SEPARATOR);
            while (listChanges.next()) {
                changeIndex = listChanges.getIndex();
                changeType = listChanges.getType();
                if (changeType == 2) {
                    this.collapsedElements.add(changeIndex, Barcode.BLACK, 1);
                    int viewIndex = this.collapsedElements.getColourIndex(changeIndex, Barcode.BLACK);
                    this.updates.addInsert(viewIndex);
                    continue;
                }
                if (changeType == 1) {
                    if (this.collapsedElements.get(changeIndex) != Barcode.BLACK) continue;
                    int viewIndex = this.collapsedElements.getColourIndex(changeIndex, Barcode.BLACK);
                    this.updates.addUpdate(viewIndex);
                    continue;
                }
                if (changeType != 0) continue;
                Object oldColor = this.collapsedElements.get(changeIndex);
                if (oldColor == Barcode.BLACK) {
                    int viewIndex = this.collapsedElements.getColourIndex(changeIndex, Barcode.BLACK);
                    this.updates.addDelete(viewIndex);
                }
                this.collapsedElements.remove(changeIndex, 1);
            }
            listChanges.reset();
            while (listChanges.next()) {
                changeIndex = listChanges.getIndex();
                changeType = listChanges.getType();
                if (changeType == 2) {
                    int group = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getColourIndex(changeIndex, true, SEPARATOR);
                    this.updateGroup(group, groupCount, true);
                    continue;
                }
                if (changeType == 1) {
                    int group = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getColourIndex(changeIndex, true, SEPARATOR);
                    if (group > 0) {
                        this.updateGroup(group - 1, groupCount, true);
                    }
                    this.updateGroup(group, groupCount, true);
                    if (group >= groupCount - 1) continue;
                    this.updateGroup(group + 1, groupCount, true);
                    continue;
                }
                if (changeType != 0 || changeIndex >= ((SeparatorInjectorList)this.separatorSource).insertedSeparators.size()) continue;
                int group = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getColourIndex(changeIndex, true, SEPARATOR);
                this.updateGroup(group, groupCount, true);
            }
        }
        this.updates.commitEvent();
    }

    private void updateGroup(int group, int groupCount, boolean fireEvents) {
        int separatorStart;
        Separator separator = (Separator)((SeparatorInjectorList)this.separatorSource).separators.get(group).get();
        int limit = separator.getLimit();
        int nextGroup = group + 1;
        int separatorEnd = nextGroup == groupCount ? ((SeparatorInjectorList)this.separatorSource).insertedSeparators.size() : ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getIndex(nextGroup, SEPARATOR);
        int size = separatorEnd - (separatorStart = ((SeparatorInjectorList)this.separatorSource).insertedSeparators.getIndex(group, SEPARATOR)) - 1;
        if (size < this.minimumSizeForSeparator) {
            this.setVisible(separatorStart, Barcode.WHITE, fireEvents);
            int i = separatorStart + 1;
            while (i < separatorEnd) {
                this.setVisible(i, Barcode.BLACK, fireEvents);
                ++i;
            }
        } else {
            this.setVisible(separatorStart, Barcode.BLACK, fireEvents);
            int i = separatorStart + 1;
            while (i < separatorEnd) {
                boolean withinLimit = i - separatorStart <= limit;
                this.setVisible(i, withinLimit ? Barcode.BLACK : Barcode.WHITE, fireEvents);
                ++i;
            }
        }
    }

    private void setVisible(int index, Object colour, boolean fireEvents) {
        Object previousColour = this.collapsedElements.get(index);
        if (colour == previousColour) {
            return;
        }
        if (colour == Barcode.WHITE) {
            int viewIndex = this.collapsedElements.getColourIndex(index, Barcode.BLACK);
            if (fireEvents) {
                this.updates.addDelete(viewIndex);
            }
            this.collapsedElements.set(index, Barcode.WHITE, 1);
        } else if (colour == Barcode.BLACK) {
            this.collapsedElements.set(index, Barcode.BLACK, 1);
            int viewIndex = this.collapsedElements.getColourIndex(index, Barcode.BLACK);
            if (fireEvents) {
                this.updates.addInsert(viewIndex);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void dispose() {
        this.separatorSource.dispose();
        this.separatorSource.source.dispose();
        super.dispose();
    }

    public static interface Separator<E> {
        public int getLimit();

        public void setLimit(int var1);

        public List<E> getGroup();

        public E first();

        public int size();
    }

    static class SeparatorInjectorList<E>
    extends TransformedList<E, E> {
        private final Grouper<E> grouper;
        private Barcode insertedSeparators;
        private SimpleTree<GroupSeparator> separators;
        private int defaultLimit;

        public SeparatorInjectorList(SortedList<E> source, int defaultLimit) {
            super(source);
            this.defaultLimit = defaultLimit;
            GrouperClient grouperClient = new GrouperClient();
            this.grouper = new Grouper<E>(source, grouperClient);
            this.rebuildSeparators();
            source.addListEventListener(this);
        }

        private void rebuildSeparators() {
            this.insertedSeparators = new Barcode();
            this.separators = new SimpleTree();
            this.insertedSeparators.add(0, SOURCE_ELEMENT, this.source.size());
            BarcodeIterator i = this.grouper.getBarcode().iterator();
            while (i.hasNextColour(Grouper.UNIQUE)) {
                i.nextColour(Grouper.UNIQUE);
                int groupIndex = i.getColourIndex(Grouper.UNIQUE);
                int sourceIndex = i.getIndex();
                this.insertedSeparators.add(groupIndex + sourceIndex, SEPARATOR, 1);
                Element<GroupSeparator> node = this.separators.add(groupIndex, new GroupSeparator(), 1);
                node.get().setNode(node);
                node.get().applyLimit(this.defaultLimit, false);
            }
            int i2 = 0;
            while (i2 < this.separators.size()) {
                this.separators.get(i2).get().updateCachedValues();
                ++i2;
            }
        }

        @Override
        public E get(int index) {
            Object type = this.insertedSeparators.get(index);
            if (type == SEPARATOR) {
                return (E)this.separators.get(this.getSeparatorIndex(index)).get();
            }
            if (type == SOURCE_ELEMENT) {
                return this.source.get(this.getSourceIndex(index));
            }
            throw new IllegalStateException();
        }

        @Override
        protected int getSourceIndex(int mutationIndex) {
            Object type = this.insertedSeparators.get(mutationIndex);
            if (type == SEPARATOR) {
                throw new IllegalArgumentException("No source index exists for the separator located at index " + mutationIndex);
            }
            if (type == SOURCE_ELEMENT) {
                return this.insertedSeparators.getColourIndex(mutationIndex, SOURCE_ELEMENT);
            }
            throw new IllegalStateException();
        }

        protected int getSeparatorIndex(int mutationIndex) {
            Object type = this.insertedSeparators.get(mutationIndex);
            if (type == SEPARATOR) {
                return this.insertedSeparators.getColourIndex(mutationIndex, SEPARATOR);
            }
            if (type == SOURCE_ELEMENT) {
                return -1;
            }
            throw new IllegalStateException();
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public int size() {
            return this.insertedSeparators.size();
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            SortedList sortedSource = (SortedList)this.source;
            Comparator sourceComparator = sortedSource.getComparator();
            if (sourceComparator != this.grouper.getComparator()) {
                this.grouper.setComparator(sourceComparator);
                this.rebuildSeparators();
                return;
            }
            this.updates.beginEvent(true);
            if (listChanges.isReordering()) {
                int[] previousIndices = listChanges.getReorderMap();
                int[] reorderMap = new int[this.insertedSeparators.size()];
                int groupStartIndex = -1;
                int groupEndIndex = 0;
                int group = -1;
                int i = 0;
                while (i < previousIndices.length) {
                    int previousIndex;
                    if (i == groupEndIndex) {
                        reorderMap[i + ++group] = i + group;
                        groupStartIndex = groupEndIndex;
                        int nextGroup = group + 1;
                        int n = groupEndIndex = nextGroup < this.separators.size() ? this.separators.get(nextGroup).get().start() : this.insertedSeparators.size();
                    }
                    if ((previousIndex = previousIndices[i]) < groupStartIndex || previousIndex >= groupEndIndex) {
                        throw new IllegalStateException();
                    }
                    reorderMap[i + group + 1] = previousIndex + group + 1;
                    ++i;
                }
                this.updates.reorder(reorderMap);
            } else {
                this.grouper.listChanged(listChanges);
            }
            int i = 0;
            while (i < this.separators.size()) {
                this.separators.get(i).get().updateCachedValues();
                ++i;
            }
            this.updates.commitEvent();
        }

        class GroupSeparator
        implements Separator<E> {
            private int limit = Integer.MAX_VALUE;
            private int size;
            private E first;
            private Element<GroupSeparator> node = null;

            GroupSeparator() {
            }

            @Override
            public int getLimit() {
                return this.limit;
            }

            @Override
            public void setLimit(int limit) {
                this.applyLimit(limit, true);
            }

            protected void applyLimit(int limit, boolean fireEvents) {
                if (this.limit == limit) {
                    return;
                }
                if (this.node == null) {
                    return;
                }
                this.limit = limit;
                if (fireEvents) {
                    SeparatorInjectorList.this.updates.beginEvent();
                    int groupIndex = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1);
                    int separatorIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(groupIndex, SEPARATOR);
                    SeparatorInjectorList.this.updates.addUpdate(separatorIndex);
                    SeparatorInjectorList.this.updates.commitEvent();
                }
            }

            @Override
            public List<E> getGroup() {
                if (this.node == null) {
                    return Collections.emptyList();
                }
                return SeparatorInjectorList.this.source.subList(this.start(), this.end());
            }

            @Override
            public E first() {
                return this.first;
            }

            @Override
            public int size() {
                return this.size;
            }

            public void setNode(Element<GroupSeparator> node) {
                this.node = node;
            }

            private int start() {
                if (this.node == null) {
                    throw new IllegalStateException();
                }
                int separatorIndex = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1);
                if (separatorIndex == -1) {
                    throw new IllegalStateException();
                }
                int groupStartIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(separatorIndex, SEPARATOR);
                return groupStartIndex - separatorIndex;
            }

            private int end() {
                if (this.node == null) {
                    throw new IllegalStateException();
                }
                int nextSeparatorIndex = SeparatorInjectorList.this.separators.indexOfNode(this.node, (byte)1) + 1;
                if (nextSeparatorIndex == 0) {
                    throw new IllegalStateException();
                }
                int nextGroupStartIndex = nextSeparatorIndex == SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) ? SeparatorInjectorList.this.insertedSeparators.size() : SeparatorInjectorList.this.insertedSeparators.getIndex(nextSeparatorIndex, SEPARATOR);
                return nextGroupStartIndex - nextSeparatorIndex;
            }

            public void updateCachedValues() {
                if (this.node != null) {
                    int start = this.start();
                    int end = this.end();
                    this.first = SeparatorInjectorList.this.source.get(start);
                    this.size = end - start;
                } else {
                    this.first = null;
                    this.size = 0;
                }
            }

            public String toString() {
                return this.size() + " elements starting with \"" + this.first() + "\"";
            }
        }

        private class GrouperClient
        implements Grouper.Client<E> {
            private GrouperClient() {
            }

            @Override
            public void groupChanged(int index, int groupIndex, int groupChangeType, boolean primary, int elementChangeType, E oldValue, E newValue) {
                int calculatedSeparatorPos;
                int separatorsIndex;
                int collapsedGroupStartIndex;
                Element<GroupSeparator> node;
                int expandedIndex;
                boolean fixSeparatorForInsertGroupUpdateElement = false;
                if (groupChangeType == 2) {
                    expandedIndex = index + groupIndex;
                    SeparatorInjectorList.this.insertedSeparators.add(expandedIndex, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(expandedIndex);
                    node = SeparatorInjectorList.this.separators.add(groupIndex, new GroupSeparator(), 1);
                    node.get().setNode(node);
                    node.get().setLimit(SeparatorInjectorList.this.defaultLimit);
                } else if (groupChangeType == 1) {
                    expandedIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(groupIndex, SEPARATOR);
                    SeparatorInjectorList.this.updates.addUpdate(expandedIndex);
                } else if (groupChangeType == 0) {
                    expandedIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(groupIndex, SEPARATOR);
                    SeparatorInjectorList.this.insertedSeparators.remove(expandedIndex, 1);
                    SeparatorInjectorList.this.updates.addDelete(expandedIndex);
                    node = SeparatorInjectorList.this.separators.get(groupIndex);
                    SeparatorInjectorList.this.separators.remove(node);
                    node.get().setNode(null);
                    node.get().updateCachedValues();
                    --groupIndex;
                }
                if (elementChangeType == 2) {
                    expandedIndex = index + groupIndex + 1;
                    SeparatorInjectorList.this.insertedSeparators.add(expandedIndex, SOURCE_ELEMENT, 1);
                    SeparatorInjectorList.this.updates.addInsert(expandedIndex);
                } else if (elementChangeType == 1) {
                    int nextSeparatorsIndex;
                    int separatorCount;
                    expandedIndex = index + groupIndex + 1;
                    if (groupChangeType == 2 && groupIndex + 1 < (separatorCount = SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR)) && (nextSeparatorsIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(groupIndex + 1, SEPARATOR)) == expandedIndex) {
                        ++expandedIndex;
                        fixSeparatorForInsertGroupUpdateElement = true;
                    }
                    SeparatorInjectorList.this.updates.addUpdate(expandedIndex);
                } else if (elementChangeType == 0) {
                    expandedIndex = index + groupIndex + 1;
                    SeparatorInjectorList.this.insertedSeparators.remove(expandedIndex, 1);
                    SeparatorInjectorList.this.updates.addDelete(expandedIndex);
                }
                if (fixSeparatorForInsertGroupUpdateElement) {
                    int wrongSeparatorIndex = index + groupIndex + 1;
                    assert (wrongSeparatorIndex == SeparatorInjectorList.this.insertedSeparators.getIndex(groupIndex + 1, SEPARATOR));
                    SeparatorInjectorList.this.insertedSeparators.remove(wrongSeparatorIndex, 1);
                    SeparatorInjectorList.this.updates.addDelete(wrongSeparatorIndex);
                    SeparatorInjectorList.this.insertedSeparators.add(wrongSeparatorIndex + 1, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(wrongSeparatorIndex + 1);
                }
                int shiftGroupIndex = groupIndex + 1;
                if (groupChangeType == 0 && elementChangeType != 2 && shiftGroupIndex < SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) && shiftGroupIndex < SeparatorInjectorList.this.grouper.getBarcode().colourSize(Grouper.UNIQUE) && (collapsedGroupStartIndex = SeparatorInjectorList.this.grouper.getBarcode().getIndex(shiftGroupIndex, Grouper.UNIQUE)) + shiftGroupIndex < (separatorsIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(shiftGroupIndex, SEPARATOR))) {
                    SeparatorInjectorList.this.insertedSeparators.remove(separatorsIndex, 1);
                    SeparatorInjectorList.this.updates.addDelete(separatorsIndex);
                    SeparatorInjectorList.this.insertedSeparators.add(collapsedGroupStartIndex + shiftGroupIndex, SEPARATOR, 1);
                    SeparatorInjectorList.this.updates.addInsert(collapsedGroupStartIndex + shiftGroupIndex);
                }
                if (groupChangeType == 1 && elementChangeType == 1 && shiftGroupIndex < SeparatorInjectorList.this.insertedSeparators.colourSize(SEPARATOR) && shiftGroupIndex < SeparatorInjectorList.this.grouper.getBarcode().colourSize(Grouper.UNIQUE) && (calculatedSeparatorPos = (collapsedGroupStartIndex = SeparatorInjectorList.this.grouper.getBarcode().getIndex(shiftGroupIndex, Grouper.UNIQUE)) + shiftGroupIndex) != (separatorsIndex = SeparatorInjectorList.this.insertedSeparators.getIndex(shiftGroupIndex, SEPARATOR))) {
                    SeparatorInjectorList.this.insertedSeparators.remove(separatorsIndex, 1);
                    SeparatorInjectorList.this.updates.addDelete(separatorsIndex);
                    SeparatorInjectorList.this.insertedSeparators.add(calculatedSeparatorPos, SEPARATOR, 1);
                    int insertPos = calculatedSeparatorPos < separatorsIndex ? calculatedSeparatorPos : calculatedSeparatorPos - 1;
                    SeparatorInjectorList.this.updates.addInsert(insertPos);
                }
            }
        }
    }
}

