/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;

public class PluggableList<E>
extends TransformedList<E, E> {
    public PluggableList(ListEventPublisher publisher, ReadWriteLock lock) {
        this((EventList<E>)new BasicEventList(publisher, lock));
    }

    public PluggableList(EventList<E> source) {
        super(source);
        source.addListEventListener(this);
    }

    public EventList<E> createSourceList() {
        return new BasicEventList(this.getPublisher(), this.getReadWriteLock());
    }

    public void setSource(EventList<E> source) {
        this.getReadWriteLock().writeLock().lock();
        try {
            if (this.source == null) {
                throw new IllegalStateException("setSource may not be called on a disposed PluggableList");
            }
            if (source == null) {
                throw new IllegalArgumentException("source may not be null");
            }
            if (!this.getReadWriteLock().equals(source.getReadWriteLock())) {
                throw new IllegalArgumentException("source list must share lock with PluggableList");
            }
            if (!this.getPublisher().equals(source.getPublisher())) {
                throw new IllegalArgumentException("source list must share publisher with PluggableList");
            }
            if (this.source == source) {
                return;
            }
            this.updates.beginEvent();
            int i = 0;
            int n = this.size();
            while (i < n) {
                this.updates.elementDeleted(0, this.get(i));
                ++i;
            }
            this.source.removeListEventListener(this);
            this.source = source;
            this.source.addListEventListener(this);
            i = 0;
            n = this.size();
            while (i < n) {
                this.updates.elementInserted(i, this.get(i));
                ++i;
            }
            this.updates.commitEvent();
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    @Override
    public void dispose() {
        if (this.source != null) {
            this.source.removeListEventListener(this);
        }
        this.source = null;
    }
}

