/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;

public final class FunctionList<S, E>
extends TransformedList<S, E>
implements RandomAccess {
    private final List<S> sourceElements;
    private final List<E> mappedElements;
    private AdvancedFunction<S, E> forward;
    private Function<E, S> reverse;

    public FunctionList(EventList<S> source, Function<S, E> forward) {
        this(source, forward, null);
    }

    public FunctionList(EventList<S> source, Function<S, E> forward, Function<E, S> reverse) {
        super(source);
        this.updateForwardFunction(forward);
        this.setReverseFunction(reverse);
        this.sourceElements = new ArrayList<S>(source);
        this.mappedElements = new ArrayList(source.size());
        int i = 0;
        int n = source.size();
        while (i < n) {
            this.mappedElements.add(this.forward(source.get(i)));
            ++i;
        }
        source.addListEventListener(this);
    }

    private E forward(S s) {
        return (E)this.forward.evaluate(s);
    }

    private E forward(E e, S s) {
        return this.forward.reevaluate(s, e);
    }

    private S reverse(E e) {
        if (this.reverse == null) {
            throw new IllegalStateException("A reverse mapping function must be specified to support this List operation");
        }
        return this.reverse.evaluate(e);
    }

    public void setForwardFunction(Function<S, E> forward) {
        this.updateForwardFunction(forward);
        this.updates.beginEvent(true);
        int i = 0;
        int n = this.source.size();
        while (i < n) {
            E oldValue = this.mappedElements.set(i, this.forward(this.source.get(i)));
            this.updates.elementUpdated(i, oldValue);
            ++i;
        }
        this.updates.commitEvent();
    }

    private void updateForwardFunction(Function<S, E> forward) {
        if (forward == null) {
            throw new IllegalArgumentException("forward Function may not be null");
        }
        this.forward = forward instanceof AdvancedFunction ? (AdvancedFunction<Object, Object>)forward : new AdvancedFunctionAdapter<S, E>(forward);
    }

    public Function<S, E> getForwardFunction() {
        if (this.forward instanceof AdvancedFunctionAdapter) {
            return ((AdvancedFunctionAdapter)this.forward).getDelegate();
        }
        return this.forward;
    }

    public void setReverseFunction(Function<E, S> reverse) {
        this.reverse = reverse;
    }

    public Function<E, S> getReverseFunction() {
        return this.reverse;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void listChanged(ListEvent<S> listChanges) {
        block4: {
            this.updates.beginEvent(true);
            if (!listChanges.isReordering()) ** GOTO lbl38
            reorderMap = listChanges.getReorderMap();
            originalMappedElements = new ArrayList<E>(this.mappedElements);
            i = 0;
            while (i < reorderMap.length) {
                sourceIndex = reorderMap[i];
                this.mappedElements.set(i, originalMappedElements.get(sourceIndex));
                ++i;
            }
            this.updates.reorder(reorderMap);
            break block4;
lbl-1000:
            // 1 sources

            {
                changeIndex = listChanges.getIndex();
                changeType = listChanges.getType();
                if (changeType == 2) {
                    newValue = this.source.get(changeIndex);
                    newValueTransformed = this.forward(newValue);
                    this.sourceElements.add(changeIndex, newValue);
                    this.mappedElements.add(changeIndex, newValueTransformed);
                    this.updates.elementInserted(changeIndex, newValueTransformed);
                    continue;
                }
                if (changeType == 1) {
                    oldValueTransformed = this.get(changeIndex);
                    newValue = this.source.get(changeIndex);
                    newValueTransformed = this.forward(oldValueTransformed, newValue);
                    this.sourceElements.set(changeIndex, newValue);
                    this.mappedElements.set(changeIndex, newValueTransformed);
                    this.updates.elementUpdated(changeIndex, oldValueTransformed, newValueTransformed);
                    continue;
                }
                if (changeType != 0) continue;
                oldValue = this.sourceElements.remove(changeIndex);
                oldValueTransformed = this.mappedElements.remove(changeIndex);
                this.forward.dispose(oldValue, oldValueTransformed);
                this.updates.elementDeleted(changeIndex, oldValueTransformed);
lbl38:
                // 5 sources

                ** while (listChanges.next())
            }
        }
        this.updates.commitEvent();
    }

    @Override
    public E get(int index) {
        return this.mappedElements.get(index);
    }

    @Override
    public E remove(int index) {
        E removed = this.get(index);
        this.source.remove(index);
        return removed;
    }

    @Override
    public E set(int index, E value) {
        E updated = this.get(index);
        this.source.set(index, this.reverse(value));
        return updated;
    }

    @Override
    public void add(int index, E value) {
        this.source.add(index, this.reverse(value));
    }

    public static interface AdvancedFunction<A, B>
    extends Function<A, B> {
        public B reevaluate(A var1, B var2);

        public void dispose(A var1, B var2);
    }

    private static final class AdvancedFunctionAdapter<A, B>
    implements AdvancedFunction<A, B> {
        private final Function<A, B> delegate;

        public AdvancedFunctionAdapter(Function<A, B> delegate) {
            this.delegate = delegate;
        }

        @Override
        public B evaluate(A sourceValue) {
            return this.delegate.evaluate(sourceValue);
        }

        @Override
        public B reevaluate(A sourceValue, B transformedValue) {
            return this.evaluate(sourceValue);
        }

        @Override
        public void dispose(A sourceValue, B transformedValue) {
        }

        public Function getDelegate() {
            return this.delegate;
        }
    }

    public static interface Function<A, B> {
        public B evaluate(A var1);
    }
}

