/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugListLockingCheck
extends Thread {
    private static DebugListLockingCheck INSTANCE;
    private boolean terminated = false;
    private Logger log = LoggerFactory.getLogger((String)"ca.odell.glazedlists.DebugLock");
    private Vector<DebugEvent> debugEventLock = new Vector();
    public static final long UNREASONABLE_LOCKING_DURATION_MS = 40000L;

    public static DebugListLockingCheck getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DebugListLockingCheck();
            INSTANCE.start();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminated) {
            try {
                Object object;
                if (this.debugEventLock.size() > 0) {
                    object = this.debugEventLock;
                    synchronized (object) {
                        this.log.info("running check DebugEventLock with size " + this.debugEventLock.size());
                        for (DebugEvent de : this.debugEventLock) {
                            if (!de.checkForHang()) continue;
                            this.log.info("please check this current thread, because locking is more than 2 minute. with time locking " + TimeUnit.MILLISECONDS.toMinutes(de.timeSoFar()) + " minutes");
                            this.log.info(de.getStackTrace());
                        }
                        this.log.info("running check DebugEventLock done");
                    }
                }
                object = this;
                synchronized (object) {
                    this.wait(60000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(DebugListLockingCheck.stackTraceToString(e.getStackTrace()));
            }
        }
    }

    public void add(Thread currentThread) {
        this.debugEventLock.add(new DebugEvent(String.valueOf(DebugListLockingCheck.stackTraceToString(currentThread.getStackTrace())) + " thread-name[" + currentThread.getName() + "]", System.currentTimeMillis(), currentThread));
    }

    public void remove(Thread currentThread) {
        this.debugEventLock.remove(new DebugEvent("", 0L, currentThread));
    }

    private static String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuilder result = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String indentation = "    ";
            result.append("\n" + indentation + stackTraceElement);
            ++n2;
        }
        return result.toString();
    }

    public class DebugEvent {
        private String stackTrace;
        private long timeStartLock;
        private long timeEndLock;
        private Thread currentThread;

        public DebugEvent(String stackTrace, long timeStartLock, Thread currentThread) {
            this.stackTrace = stackTrace;
            this.timeStartLock = timeStartLock;
            this.currentThread = currentThread;
            stackTrace = DebugListLockingCheck.stackTraceToString(currentThread.getStackTrace());
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        public long getTimeStartLock() {
            return this.timeStartLock;
        }

        public void setTimeStartLock(long timeStartLock) {
            this.timeStartLock = timeStartLock;
        }

        public long getTimeEndLock() {
            return this.timeEndLock;
        }

        public void setTimeEndLock(long timeEndLock) {
            this.timeEndLock = timeEndLock;
        }

        public Thread getCurrentThread() {
            return this.currentThread;
        }

        public void setCurrentThread(Thread currentThread) {
            this.currentThread = currentThread;
        }

        public boolean equals(Object obj) {
            DebugEvent de = (DebugEvent)obj;
            return this.getCurrentThread().equals(de.getCurrentThread());
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.timeStartLock;
        }

        public boolean checkForHang() {
            return this.timeSoFar() > 40000L;
        }
    }
}

