/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.DebugListLockingCheck;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugList<E>
extends AbstractEventList<E> {
    private boolean lockCheckingEnabled;
    private final Set<Thread> sanctionedReaderThreads = new HashSet<Thread>();
    private final Set<Thread> sanctionedWriterThreads = new HashSet<Thread>();
    private EventList<E> delegate;
    private final ListEventListener<E> delegateWatcher = new ListEventForwarder();
    private final DebugReadWriteLock debugReadWriteLock;

    public DebugList() {
        this(null, new DebugReadWriteLock());
    }

    private DebugList(ListEventPublisher publisher, DebugReadWriteLock debugReadWriteLock) {
        this.debugReadWriteLock = debugReadWriteLock;
        this.delegate = new BasicEventList(publisher, this.debugReadWriteLock);
        this.delegate.addListEventListener(this.delegateWatcher);
    }

    public boolean isLockCheckingEnabled() {
        return this.lockCheckingEnabled;
    }

    public void setLockCheckingEnabled(boolean lockCheckingEnabled) {
        this.lockCheckingEnabled = lockCheckingEnabled;
    }

    public Set<Thread> getSanctionedReaderThreads() {
        return this.sanctionedReaderThreads;
    }

    public Set<Thread> getSanctionedWriterThreads() {
        return this.sanctionedWriterThreads;
    }

    public <E> DebugList<E> createNewDebugList() {
        return new DebugList<E>(this.getPublisher(), this.debugReadWriteLock);
    }

    protected void beforeReadOperation() {
        if (!this.sanctionedReaderThreads.isEmpty() && !this.sanctionedReaderThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a read operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingReadOrWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the readLock prior to a read operation");
        }
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
        if (!this.sanctionedWriterThreads.isEmpty() && !this.sanctionedWriterThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a write operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the writeLock prior to a write operation");
        }
    }

    protected void afterWriteOperation() {
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    @Override
    public ListEventPublisher getPublisher() {
        return this.delegate.getPublisher();
    }

    @Override
    public E get(int index) {
        this.beforeReadOperation();
        try {
            Object e = this.delegate.get(index);
            return e;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int size() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean contains(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.contains(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.containsAll(collection);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean equals(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.equals(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int hashCode() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int indexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.indexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.lastIndexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean isEmpty() {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public Object[] toArray() {
        this.beforeReadOperation();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.beforeReadOperation();
        try {
            T[] TArray = this.delegate.toArray(array);
            return TArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public String toString() {
        this.beforeReadOperation();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.afterReadOperation();
        }
    }

    @Override
    public boolean add(E value) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.add(value);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean remove(Object toRemove) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.remove(toRemove);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(index, values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean removeAll(Collection<?> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.removeAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public boolean retainAll(Collection<?> values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.retainAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void clear() {
        this.beforeWriteOperation();
        try {
            this.delegate.clear();
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public E set(int index, E value) {
        this.beforeWriteOperation();
        try {
            E e = this.delegate.set(index, value);
            return e;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void add(int index, E value) {
        this.beforeWriteOperation();
        try {
            this.delegate.add(index, value);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public E remove(int index) {
        this.beforeWriteOperation();
        try {
            Object e = this.delegate.remove(index);
            return e;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    @Override
    public void dispose() {
        this.delegate.removeListEventListener(this.delegateWatcher);
        this.delegate = null;
    }

    private static class DebugReadWriteLock
    implements ReadWriteLock {
        private final DebugLock readLock;
        private final DebugLock writeLock;

        public DebugReadWriteLock() {
            ReadWriteLock decorated = LockFactory.DEFAULT.createReadWriteLock();
            this.readLock = new DebugLock(decorated.readLock(), null);
            this.writeLock = new DebugLock(decorated.writeLock(), this.readLock);
        }

        @Override
        public Lock readLock() {
            return this.readLock;
        }

        @Override
        public Lock writeLock() {
            return this.writeLock;
        }

        public boolean isThreadHoldingWriteLock() {
            return this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadOrWriteLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread()) || this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        private static class DebugLock
        implements Lock {
            private final Lock delegate;
            private final DebugLock readLock;
            private final List<Thread> threadsHoldingLock = Collections.synchronizedList(new ArrayList());
            private Logger log = LoggerFactory.getLogger((String)"ca.odell.glazedlists.DebugLock");

            public DebugLock(Lock delegate, DebugLock readLock) {
                this.delegate = delegate;
                this.readLock = readLock;
            }

            @Override
            public void lock() {
                if (this.readLock != null && this.readLock.getThreadsHoldingLock().contains(Thread.currentThread())) {
                    throw new IllegalStateException("DebugList detected an attempt to acquire a writeLock from a thread already owning a readLock (deadlock)");
                }
                DebugListLockingCheck.getInstance().add(Thread.currentThread());
                this.delegate.lock();
                this.threadsHoldingLock.add(Thread.currentThread());
            }

            private static String stackTraceToString(StackTraceElement[] stackTrace) {
                StringBuilder result = new StringBuilder();
                StackTraceElement[] stackTraceElementArray = stackTrace;
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                    String indentation = "    ";
                    result.append("\n" + indentation + stackTraceElement);
                    ++n2;
                }
                return result.toString();
            }

            @Override
            public boolean tryLock() {
                if (this.readLock != null && this.readLock.getThreadsHoldingLock().contains(Thread.currentThread())) {
                    throw new IllegalStateException("DebugList detected an attempt to acquire a writeLock from a thread already owning a readLock (deadlock)");
                }
                boolean success = this.delegate.tryLock();
                if (success) {
                    this.threadsHoldingLock.add(Thread.currentThread());
                }
                return success;
            }

            @Override
            public void unlock() {
                String st = "";
                this.delegate.unlock();
                DebugListLockingCheck.getInstance().remove(Thread.currentThread());
                this.threadsHoldingLock.remove(Thread.currentThread());
            }

            public List<Thread> getThreadsHoldingLock() {
                return this.threadsHoldingLock;
            }
        }
    }

    private class ListEventForwarder
    implements ListEventListener<E> {
        private ListEventForwarder() {
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            DebugList.this.updates.forwardEvent(listChanges);
        }
    }
}

