/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.zoom.internal;

import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.zoom.ZoomLevel;
import com.teamdev.jxbrowser.zoom.ZoomLevels;
import com.teamdev.jxbrowser.zoom.event.ZoomLevelsEvent;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomLevelValue;
import com.teamdev.jxbrowser.zoom.internal.rpc.ZoomServiceStub;

public final class ZoomLevelsImpl
extends CloseableImpl
implements ZoomLevels {
    private final NewServiceConnection<ZoomServiceStub> rpc;

    public ZoomLevelsImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.rpc = new NewServiceConnection<ZoomServiceStub>(engine.id(), engine.connection(), ZoomServiceStub::new);
    }

    @Override
    public ZoomLevel defaultLevel() {
        this.checkNotClosed();
        return ZoomLevel.of(((ZoomLevelValue)this.rpc.invoke(this.rpc.stub()::getDefaultZoomLevel, ProtobufUtil.empty())).getZoomLevel());
    }

    @Override
    public void defaultLevel(ZoomLevel zoomLevel) {
        Preconditions.checkNotNull(zoomLevel);
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setDefaultZoomLevel, ZoomLevelValue.newBuilder().setZoomLevel(zoomLevel.value()).build());
    }

    @Override
    public <E extends ZoomLevelsEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }
}

