/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class MacEditorCommand {
    private static final Map<KeyPressed, EditorCommand> commands = new HashMap<KeyPressed, EditorCommand>();

    public static Optional<EditorCommand> of(KeyPressed event) {
        Preconditions.checkNotNull(event);
        KeyPressed keyPressed = KeyPressed.newBuilder(event.keyCode()).keyModifiers(event.keyModifiers()).build();
        return Optional.ofNullable(commands.get(keyPressed));
    }

    private MacEditorCommand() {
    }

    private static KeyModifiers metaDown() {
        return KeyModifiers.newBuilder().metaDown(true).build();
    }

    private static KeyModifiers shiftDown() {
        return KeyModifiers.newBuilder().shiftDown(true).build();
    }

    private static KeyModifiers altDown() {
        return KeyModifiers.newBuilder().altDown(true).build();
    }

    private static KeyPressed getKeyStroke(KeyCode keyCode, KeyModifiers ... modifiers) {
        KeyModifiers.Builder builder = KeyModifiers.newBuilder();
        for (KeyModifiers modifier : modifiers) {
            if (modifier.isMetaDown()) {
                builder.metaDown(true);
            }
            if (modifier.isControlDown()) {
                builder.controlDown(true);
            }
            if (modifier.isAltDown()) {
                builder.altDown(true);
            }
            if (modifier.isAltGraphDown()) {
                builder.altGraphDown(true);
            }
            if (!modifier.isShiftDown()) continue;
            builder.shiftDown(true);
        }
        return KeyPressed.newBuilder(keyCode).keyModifiers(builder.build()).build();
    }

    static {
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_C, MacEditorCommand.metaDown()), EditorCommand.copy());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_X, MacEditorCommand.metaDown()), EditorCommand.cut());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_V, MacEditorCommand.metaDown()), EditorCommand.paste());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_A, MacEditorCommand.metaDown()), EditorCommand.selectAll());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_Z, MacEditorCommand.metaDown()), EditorCommand.undo());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_Z, MacEditorCommand.metaDown(), MacEditorCommand.shiftDown()), EditorCommand.redo());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_BACK, MacEditorCommand.altDown()), EditorCommand.deleteWordBackward());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_DELETE, MacEditorCommand.altDown()), EditorCommand.deleteWordForward());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_BACK, MacEditorCommand.metaDown()), EditorCommand.deleteToBeginningOfLine());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_RIGHT, MacEditorCommand.altDown()), EditorCommand.moveWordRight());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_LEFT, MacEditorCommand.altDown()), EditorCommand.moveWordLeft());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_LEFT, MacEditorCommand.metaDown()), EditorCommand.moveToBeginningOfLine());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_LEFT, MacEditorCommand.metaDown(), MacEditorCommand.shiftDown()), EditorCommand.moveToBeginningOfLineAndModifySelection());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_RIGHT, MacEditorCommand.metaDown()), EditorCommand.moveToEndOfLine());
        commands.put(MacEditorCommand.getKeyStroke(KeyCode.KEY_CODE_RIGHT, MacEditorCommand.metaDown(), MacEditorCommand.shiftDown()), EditorCommand.moveToEndOfLineAndModifySelection());
    }
}

