/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.internal;

import com.teamdev.jxbrowser.logging.Logger;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.internal.rpc.Cursor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;

public final class CursorUtil {
    private static final String CURSORS_PROPERTIES_RESOURCE_WINDOWS = "/com/teamdev/jxbrowser/ui/cursors/win/cursors.properties";
    private static final String CURSORS_PROPERTIES_RESOURCE_MAC = "/com/teamdev/jxbrowser/ui/cursors/mac/cursors.properties";
    private static final String DOT_FILE_SUFFIX = ".file";
    private static final String DOT_HOTSPOT_SUFFIX = ".hotspot";
    private static final Properties cursorProperties = new Properties();

    public static Optional<URL> cursorResource(Cursor.Type cursorType) {
        String cursorFileKey = cursorType.name() + DOT_FILE_SUFFIX;
        return Optional.ofNullable(cursorProperties.getProperty(cursorFileKey)).map(CursorUtil.class::getResource);
    }

    public static Optional<Point> cursorHotspot(Cursor.Type cursorType) {
        String cursorHotSpotKey = cursorType.name() + DOT_HOTSPOT_SUFFIX;
        return Optional.ofNullable(cursorProperties.getProperty(cursorHotSpotKey)).map(CursorUtil::parsePoint);
    }

    private CursorUtil() {
    }

    private static String cursorsPropertiesResourceName() {
        if (Environment.isMac()) {
            return CURSORS_PROPERTIES_RESOURCE_MAC;
        }
        return CURSORS_PROPERTIES_RESOURCE_WINDOWS;
    }

    private static Point parsePoint(String pointValue) {
        StringTokenizer st = new StringTokenizer(pointValue, ",");
        if (st.countTokens() == 2) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                return Point.of(x, y);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse point: " + pointValue, e);
            }
        }
        throw new IllegalArgumentException("Failed to parse point: " + pointValue);
    }

    static {
        URL propertiesURL = CursorUtil.class.getResource(CursorUtil.cursorsPropertiesResourceName());
        if (propertiesURL != null) {
            try {
                InputStream inputStream = propertiesURL.openStream();
                cursorProperties.load(inputStream);
                inputStream.close();
            }
            catch (IOException ignore) {
                Logger.warn("Unable to load cursors properties from:" + propertiesURL);
            }
        }
    }
}

