/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.Point;
import com.teamdev.jxbrowser.ui.ScrollType;
import com.teamdev.jxbrowser.ui.event.MouseEvent;
import com.teamdev.jxbrowser.ui.event.MouseEvents;
import com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel;

public interface MouseWheel
extends MouseEvent {
    public static Builder newBuilder(Point location) {
        Preconditions.checkNotNull(location);
        return new Builder(location);
    }

    @Override
    default public Point location() {
        return MouseEvents.cast(this).getLocation();
    }

    @Override
    default public Point locationOnScreen() {
        return MouseEvents.cast(this).getLocationOnScreen();
    }

    default public KeyModifiers keyModifiers() {
        return MouseEvents.cast(this).getKeyModifiers();
    }

    default public ScrollType scrollType() {
        return MouseEvents.cast(this).getScrollType();
    }

    @Deprecated
    default public int unitsToScroll() {
        return MouseEvents.cast(this).getUnitsToScroll();
    }

    @Deprecated
    default public boolean isHorizontalScroll() {
        return MouseEvents.cast(this).getHorizontalScroll();
    }

    default public float deltaX() {
        return MouseEvents.cast(this).getDeltaX();
    }

    default public float deltaY() {
        return MouseEvents.cast(this).getDeltaY();
    }

    @Deprecated
    default public int scrollbarPixelsPerLine() {
        return MouseEvents.cast(this).getScrollbarPixelsPerLine();
    }

    public static final class Builder {
        private final MouseWheel.Builder builder;

        private Builder(Point location) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.MouseWheel.newBuilder().setLocation((com.teamdev.jxbrowser.ui.internal.rpc.Point)location);
        }

        public Builder locationOnScreen(Point locationOnScreen) {
            Preconditions.checkNotNull(locationOnScreen);
            this.builder.setLocationOnScreen((com.teamdev.jxbrowser.ui.internal.rpc.Point)locationOnScreen);
            return this;
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public Builder scrollType(ScrollType scrollType) {
            Preconditions.checkNotNull(scrollType);
            this.builder.setScrollType(scrollType);
            return this;
        }

        public Builder deltaX(float deltaX) {
            this.builder.setDeltaX(deltaX);
            return this;
        }

        public Builder deltaY(float deltaY) {
            this.builder.setDeltaY(deltaY);
            return this;
        }

        @Deprecated
        public Builder unitsToScroll(int unitsToScroll) {
            this.builder.setUnitsToScroll(unitsToScroll);
            return this;
        }

        @Deprecated
        public Builder scrollbarPixelsPerLine(int scrollbarPixelsPerLine) {
            Preconditions.checkArgument(scrollbarPixelsPerLine > 0);
            this.builder.setScrollbarPixelsPerLine(scrollbarPixelsPerLine);
            return this;
        }

        @Deprecated
        public Builder horizontalScroll(boolean horizontalScroll) {
            this.builder.setHorizontalScroll(horizontalScroll);
            return this;
        }

        public MouseWheel build() {
            if (this.builder.getDeltaX() == 0.0f && this.builder.getDeltaY() == 0.0f) {
                if (this.builder.getHorizontalScroll()) {
                    this.deltaX(this.builder.getUnitsToScroll() * this.builder.getScrollbarPixelsPerLine());
                } else {
                    this.deltaY(this.builder.getUnitsToScroll() * this.builder.getScrollbarPixelsPerLine());
                }
            }
            return this.builder.build();
        }
    }
}

