/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyEvent;
import com.teamdev.jxbrowser.ui.event.KeyEvents;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped;

public interface KeyTyped
extends KeyEvent {
    public static Builder newBuilder(KeyCode keyCode) {
        Preconditions.checkNotNull(keyCode);
        return new Builder(keyCode);
    }

    @Override
    default public KeyCode keyCode() {
        return KeyEvents.cast(this).getKeyCode();
    }

    @Override
    default public KeyModifiers keyModifiers() {
        return KeyEvents.cast(this).getKeyModifiers();
    }

    default public char keyChar() {
        return KeyEvents.cast(this).getKeyChar().charAt(0);
    }

    public static final class Builder {
        private final KeyTyped.Builder builder;

        private Builder(KeyCode keyCode) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.KeyTyped.newBuilder().setKeyCode(keyCode);
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public Builder keyChar(char keyChar) {
            this.builder.setKeyChar(String.valueOf(keyChar));
            return this;
        }

        public KeyTyped build() {
            return this.builder.build();
        }
    }
}

