/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.ui.event;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.ui.KeyCode;
import com.teamdev.jxbrowser.ui.KeyModifiers;
import com.teamdev.jxbrowser.ui.event.KeyEvent;
import com.teamdev.jxbrowser.ui.event.KeyEvents;
import com.teamdev.jxbrowser.ui.event.internal.rpc.KeyReleased;

public interface KeyReleased
extends KeyEvent {
    public static Builder newBuilder(KeyCode keyCode) {
        Preconditions.checkNotNull(keyCode);
        return new Builder(keyCode);
    }

    @Override
    default public KeyCode keyCode() {
        return KeyEvents.cast(this).getKeyCode();
    }

    @Override
    default public KeyModifiers keyModifiers() {
        return KeyEvents.cast(this).getKeyModifiers();
    }

    public static final class Builder {
        private final KeyReleased.Builder builder;

        private Builder(KeyCode keyCode) {
            this.builder = com.teamdev.jxbrowser.ui.event.internal.rpc.KeyReleased.newBuilder().setKeyCode(keyCode);
        }

        public Builder keyModifiers(KeyModifiers keyModifiers) {
            Preconditions.checkNotNull(keyModifiers);
            this.builder.setKeyModifiers((com.teamdev.jxbrowser.ui.event.internal.rpc.KeyModifiers)keyModifiers);
            return this;
        }

        public KeyReleased build() {
            return this.builder.build();
        }
    }
}

