/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.spellcheck.SpellChecker;
import com.teamdev.jxbrowser.spellcheck.internal.DictionaryImpl;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.DictionaryNameList;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SpellCheckerStub;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SpellCheckerImpl
extends CloseableImpl
implements SpellChecker {
    private final EngineImpl engine;
    private final Lazy<DictionaryImpl> customDictionary;
    private final NewServiceConnection<SpellCheckerStub> rpc;

    public SpellCheckerImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.engine = engine;
        this.customDictionary = new Lazy<DictionaryImpl>(() -> new DictionaryImpl(this));
        this.rpc = new NewServiceConnection<SpellCheckerStub>(engine.id(), engine.connection(), SpellCheckerStub::new);
    }

    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public boolean isEnabled() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::getEnabled, ProtobufUtil.empty())).getValue();
    }

    private void setEnabled(boolean enabled) {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setEnabled, BoolValue.of(enabled));
    }

    @Override
    public void enable() {
        this.setEnabled(true);
    }

    @Override
    public void disable() {
        this.setEnabled(false);
    }

    @Override
    public List<String> dictionaryNames() {
        this.checkNotClosed();
        return Collections.unmodifiableList(((DictionaryNameList)this.rpc.invoke(this.rpc.stub()::getDictionaryNames, ProtobufUtil.empty())).getDictionaryNameList());
    }

    @Override
    public void dictionaryNames(String ... dictionaryNames) {
        Preconditions.checkNotNullEmptyOrBlank(dictionaryNames);
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setDictionaryNames, DictionaryNameList.newBuilder().addAllDictionaryName(Arrays.asList(dictionaryNames)).build());
    }

    @Override
    public Dictionary customDictionary() {
        return this.customDictionary.get();
    }
}

