/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.spellcheck.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.spellcheck.Dictionary;
import com.teamdev.jxbrowser.spellcheck.internal.SpellCheckerImpl;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.SpellCheckDictionaryStub;
import com.teamdev.jxbrowser.spellcheck.internal.rpc.WordList;
import java.util.Collection;

public final class DictionaryImpl
extends CloseableImpl
implements Dictionary {
    private final NewServiceConnection<SpellCheckDictionaryStub> rpc;

    DictionaryImpl(SpellCheckerImpl spellChecker) {
        EngineImpl engine = spellChecker.engine();
        this.rpc = new NewServiceConnection<SpellCheckDictionaryStub>(engine.id(), engine.connection(), SpellCheckDictionaryStub::new);
    }

    @Override
    public Collection<String> words() {
        this.checkNotClosed();
        return ((WordList)this.rpc.invoke(this.rpc.stub()::getWords, ProtobufUtil.empty())).getWordList();
    }

    @Override
    public boolean add(String word) {
        Preconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::addWord, StringValue.of(word))).getValue();
    }

    @Override
    public boolean remove(String word) {
        Preconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeWord, StringValue.of(word))).getValue();
    }

    @Override
    public boolean has(String word) {
        Preconditions.checkNotNullEmptyOrBlank(word);
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasWord, StringValue.of(word))).getValue();
    }
}

