/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.search.internal;

import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.FindRequestId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.search.FindOptions;
import com.teamdev.jxbrowser.search.FindResult;
import com.teamdev.jxbrowser.search.TextFinder;
import com.teamdev.jxbrowser.search.internal.rpc.FindReplyReceived;
import com.teamdev.jxbrowser.search.internal.rpc.FindRequest;
import com.teamdev.jxbrowser.search.internal.rpc.FindResult;
import com.teamdev.jxbrowser.search.internal.rpc.StopFindingRequest;
import com.teamdev.jxbrowser.search.internal.rpc.TextFinderStub;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class TextFinderImpl
extends CloseableImpl
implements TextFinder {
    private static final AtomicInteger idGenerator = new AtomicInteger();
    private final BrowserImpl browser;
    private final Subscription findReplyReceived;
    private final NewServiceConnection<TextFinderStub> rpc;
    private final Map<FindRequestId, Consumer<FindResult>> findRequestIdConsumerMap;

    public TextFinderImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.findRequestIdConsumerMap = new HashMap<FindRequestId, Consumer<FindResult>>();
        this.rpc = new NewServiceConnection<TextFinderStub>(browser.id(), browser.engine().connection(), TextFinderStub::new);
        this.findReplyReceived = this.rpc.on(FindReplyReceived.class, event -> {
            FindRequestId requestId = event.getFindRequestId();
            if (this.findRequestIdConsumerMap.containsKey(requestId)) {
                Consumer<FindResult> callback = this.findRequestIdConsumerMap.get(requestId);
                if (event.getResult().getState() == FindResult.State.FINISHED) {
                    callback = this.findRequestIdConsumerMap.remove(requestId);
                }
                callback.accept(event.getResult());
            }
        });
    }

    @Override
    public void close() {
        this.findReplyReceived.unsubscribe();
        super.close();
    }

    @Override
    public void find(String text, Consumer<FindResult> onFindResult) {
        this.find(text, FindOptions.newBuilder().build(), onFindResult);
    }

    @Override
    public void find(String text, FindOptions options, Consumer<FindResult> onFindResult) {
        Preconditions.checkNotNull(text);
        Preconditions.checkArgument(!text.isEmpty());
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(onFindResult);
        this.checkNotClosed();
        FindRequestId requestId = FindRequestId.newBuilder().setValue(idGenerator.incrementAndGet()).build();
        this.findRequestIdConsumerMap.put(requestId, onFindResult);
        FindRequest request = FindRequest.newBuilder().setBrowserId(this.browser.id()).setSearchText(text).setOptions(Wrappers.unwrap(options, com.teamdev.jxbrowser.search.internal.rpc.FindOptions.class)).setFindRequestId(requestId).build();
        this.rpc.invokeAsync(this.rpc.stub()::find, request);
    }

    @Override
    public void stopFindingAndKeepSelection() {
        this.checkNotClosed();
        this.stopFinding(StopFindingRequest.StopFindAction.KEEP_SELECTION);
    }

    @Override
    public void stopFindingAndClearSelection() {
        this.checkNotClosed();
        this.stopFinding(StopFindingRequest.StopFindAction.CLEAR_SELECTION);
    }

    private void stopFinding(StopFindingRequest.StopFindAction stopFindAction) {
        StopFindingRequest request = StopFindingRequest.newBuilder().setBrowserId(this.browser.id()).setAction(stopFindAction).build();
        this.rpc.invoke(this.rpc.stub()::stopFinding, request);
    }
}

