/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.tls;

import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.tls.X509Certificates;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;

public interface Certificate {
    public static Certificate of(X509Certificate x509Cert) throws CertificateEncodingException {
        Preconditions.checkNotNull(x509Cert);
        return com.teamdev.jxbrowser.net.internal.rpc.Certificate.newBuilder().setDerEncodedValue(ByteString.copyFrom(x509Cert.getEncoded())).build();
    }

    default public byte[] derEncodedValue() {
        return ((com.teamdev.jxbrowser.net.internal.rpc.Certificate)this).getDerEncodedValue().toByteArray();
    }

    default public Optional<X509Certificate> toX509Certificate() {
        try {
            return Optional.of(X509Certificates.of(new ByteArrayInputStream(this.derEncodedValue())));
        }
        catch (CertificateException ignore) {
            return Optional.empty();
        }
    }
}

