/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.proxy.internal;

import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig;
import com.teamdev.jxbrowser.net.internal.rpc.ProxyStub;
import com.teamdev.jxbrowser.net.proxy.AutoDetectProxyConfig;
import com.teamdev.jxbrowser.net.proxy.CustomProxyConfig;
import com.teamdev.jxbrowser.net.proxy.DirectProxyConfig;
import com.teamdev.jxbrowser.net.proxy.Proxy;
import com.teamdev.jxbrowser.net.proxy.ProxyConfig;
import com.teamdev.jxbrowser.net.proxy.SystemProxyConfig;
import com.teamdev.jxbrowser.net.proxy.UrlProxyConfig;

public final class ProxyImpl
extends CloseableImpl
implements Proxy {
    private final NewServiceConnection<ProxyStub> rpc;

    public ProxyImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.rpc = new NewServiceConnection<ProxyStub>(engine.id(), engine.connection(), ProxyStub::new);
    }

    @Override
    public ProxyConfig config() {
        this.checkNotClosed();
        com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig response = (com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig)this.rpc.invoke(this.rpc.stub()::getConfig, ProtobufUtil.empty());
        ProxyConfig.Type proxyType = response.getType();
        if (proxyType == ProxyConfig.Type.SYSTEM) {
            return SystemProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.AUTO_DETECT) {
            return AutoDetectProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.DIRECT) {
            return DirectProxyConfig.newInstance();
        }
        if (proxyType == ProxyConfig.Type.PAC) {
            return UrlProxyConfig.newInstance(response.getAutoConfigUrl());
        }
        if (proxyType == ProxyConfig.Type.CUSTOM) {
            return CustomProxyConfig.newInstance(response.getProxyRules(), response.getProxyExceptions());
        }
        throw new IllegalStateException("Unsupported proxy type: " + proxyType);
    }

    @Override
    public void config(AutoDetectProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.rpc.invoke(this.rpc.stub()::setConfig, com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(ProxyConfig.Type.AUTO_DETECT).build());
    }

    @Override
    public void config(CustomProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.rpc.invoke(this.rpc.stub()::setConfig, com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(ProxyConfig.Type.CUSTOM).setProxyRules(proxyConfig.proxyRules()).setProxyExceptions(proxyConfig.exceptions()).build());
    }

    @Override
    public void config(DirectProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.rpc.invoke(this.rpc.stub()::setConfig, com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(ProxyConfig.Type.DIRECT).build());
    }

    @Override
    public void config(SystemProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.rpc.invoke(this.rpc.stub()::setConfig, com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(ProxyConfig.Type.SYSTEM).build());
    }

    @Override
    public void config(UrlProxyConfig proxyConfig) {
        this.checkNotClosed();
        Preconditions.checkNotNull(proxyConfig);
        this.rpc.invoke(this.rpc.stub()::setConfig, com.teamdev.jxbrowser.net.internal.rpc.ProxyConfig.newBuilder().setType(ProxyConfig.Type.PAC).setAutoConfigUrl(proxyConfig.proxyAutoConfigFileUrl()).build());
    }
}

