/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.ByteString;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestJobId;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.internal.NetworkImpl;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobData;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobStub;

public final class UrlRequestJobImpl
extends CloseableImpl<UrlRequestJobImpl>
implements UrlRequestJob {
    private final UrlRequestJobId id;
    private final NewServiceConnection<UrlRequestJobStub> rpc;

    UrlRequestJobImpl(NetworkImpl network, UrlRequestJobId urlRequestJobId) {
        this.id = urlRequestJobId;
        this.rpc = new NewServiceConnection<UrlRequestJobStub>(urlRequestJobId, network.engine().connection(), UrlRequestJobStub::new);
    }

    @Override
    public UrlRequestJob.Id id() {
        return this.id;
    }

    @Override
    public void write(byte[] data) {
        Preconditions.checkNotNull(data);
        this.checkNotClosed();
        UrlRequestJobData request = UrlRequestJobData.newBuilder().setUrlRequestJobId(this.id).setData(ByteString.copyFrom(data)).build();
        this.rpc.invoke(this.rpc.stub()::write, request);
    }

    @Override
    public void complete() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::complete, this.id);
        this.close();
    }

    @Override
    public void fail() {
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::fail, this.id);
        this.close();
    }
}

