/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.internal;

import com.teamdev.jxbrowser.callback.internal.CallbackManager;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Message;
import com.teamdev.jxbrowser.deps.com.google.protobuf.StringValue;
import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.EngineId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestJobId;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.HttpAuthPreferences;
import com.teamdev.jxbrowser.net.Network;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.NetworkCallback;
import com.teamdev.jxbrowser.net.event.NetworkEvent;
import com.teamdev.jxbrowser.net.internal.HttpAuthPreferencesImpl;
import com.teamdev.jxbrowser.net.internal.UrlRequestJobImpl;
import com.teamdev.jxbrowser.net.internal.rpc.CertificateVerifierStub;
import com.teamdev.jxbrowser.net.internal.rpc.NetworkStub;
import com.teamdev.jxbrowser.net.internal.rpc.RequestInterceptorStub;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobOptions;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class NetworkImpl
extends CloseableImpl<NetworkImpl>
implements Network {
    private final EngineImpl engine;
    private final CallbackManager callbackManager;
    private final NewServiceConnection<NetworkStub> rpc;
    private final Set<UrlRequestJobImpl> urlRequestJobs;
    private final Lazy<HttpAuthPreferencesImpl> httpAuthPreferences;

    public NetworkImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.engine = engine;
        this.urlRequestJobs = new CopyOnWriteArraySet<UrlRequestJobImpl>();
        this.httpAuthPreferences = new Lazy<HttpAuthPreferencesImpl>(() -> new HttpAuthPreferencesImpl(this));
        EngineId engineId = engine.id();
        Connection connection = engine.connection();
        this.rpc = new NewServiceConnection<NetworkStub>(engineId, connection, NetworkStub::new);
        this.callbackManager = new CallbackManager();
        this.callbackManager.addInvoker(this.rpc);
        this.callbackManager.addInvoker(new NewServiceConnection<CertificateVerifierStub>(engineId, connection, CertificateVerifierStub::new));
        this.callbackManager.addInvoker(new NewServiceConnection<RequestInterceptorStub>(engineId, connection, RequestInterceptorStub::new));
    }

    public EngineImpl engine() {
        return this.engine;
    }

    @Override
    public void close() {
        this.urlRequestJobs.forEach(CloseableImpl::close);
        super.close();
    }

    @Override
    public HttpAuthPreferences httpAuthPreferences() {
        return this.httpAuthPreferences.get();
    }

    @Override
    public String acceptLanguage() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getAcceptLanguage, ProtobufUtil.empty())).getValue();
    }

    @Override
    public void acceptLanguage(String acceptLanguage) {
        Preconditions.checkNotNullEmptyOrBlank(acceptLanguage);
        this.checkNotClosed();
        this.rpc.invoke(this.rpc.stub()::setAcceptLanguage, StringValue.of(acceptLanguage));
    }

    @Override
    public String userAgent() {
        this.checkNotClosed();
        return ((StringValue)this.rpc.invoke(this.rpc.stub()::getUserAgent, ProtobufUtil.empty())).getValue();
    }

    @Override
    public UrlRequestJob newUrlRequestJob(UrlRequestJob.Options options) {
        Preconditions.checkNotNull(options);
        this.checkNotClosed();
        UrlRequestJobImpl result = new UrlRequestJobImpl(this, (UrlRequestJobId)this.rpc.invoke(this.rpc.stub()::createUrlRequestJob, (Message)Wrappers.unwrap(options, UrlRequestJobOptions.class)));
        result.onClosed(this.urlRequestJobs::remove);
        this.urlRequestJobs.add(result);
        return result;
    }

    @Override
    public <E extends NetworkEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends NetworkCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((NetworkCallback)this.callbackManager.set(callbackClass, callback));
    }

    @Override
    public <C extends NetworkCallback> Optional<C> get(Class<C> callbackClass) {
        return this.callbackManager.get(callbackClass);
    }

    @Override
    public <C extends NetworkCallback> C remove(Class<C> callbackClass) {
        return (C)((NetworkCallback)this.callbackManager.remove(callbackClass));
    }
}

