/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestJobId;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.UploadData;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.UrlRequestJob;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.InterceptRequest;
import com.teamdev.jxbrowser.net.internal.rpc.UploadData;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface InterceptRequestCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response intercept(UrlRequestJob urlRequestJob) {
            Preconditions.checkNotNull(urlRequestJob);
            return InterceptRequest.Response.newBuilder().setInterceptWith((UrlRequestJobId)urlRequestJob.id()).build();
        }

        public static Response proceed() {
            return InterceptRequest.Response.newBuilder().setContinue(ProtobufUtil.empty()).build();
        }
    }

    public static interface Params {
        default public UrlRequest urlRequest() {
            return ((InterceptRequest.Request)this).getUrlRequest();
        }

        default public Optional<UploadData> uploadData() {
            com.teamdev.jxbrowser.net.internal.rpc.UploadData uploadData = ((InterceptRequest.Request)this).getUploadData();
            UploadData.DataCase dataCase = uploadData.getDataCase();
            if (dataCase.equals(UploadData.DataCase.BYTES_DATA)) {
                return Optional.of(uploadData.getBytesData());
            }
            if (dataCase.equals(UploadData.DataCase.TEXT_DATA)) {
                return Optional.of(uploadData.getTextData());
            }
            if (dataCase.equals(UploadData.DataCase.FORM_DATA)) {
                return Optional.of(uploadData.getFormData());
            }
            if (dataCase.equals(UploadData.DataCase.MULTIPART_FORM_DATA)) {
                return Optional.of(uploadData.getMultipartFormData());
            }
            return Optional.empty();
        }

        @Immutable
        default public List<HttpHeader> httpHeaders() {
            return Collections.unmodifiableList(((InterceptRequest.Request)this).getHttpHeaderList());
        }
    }
}

