/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.BeforeUrlRequest;
import java.util.Optional;

public interface BeforeUrlRequestCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response redirect(String newUrl) {
            Preconditions.checkNotNullEmptyOrBlank(newUrl);
            return BeforeUrlRequest.Response.newBuilder().setChangeUrlTo(newUrl).build();
        }

        public static Response proceed() {
            return BeforeUrlRequest.Response.newBuilder().setContinue(ProtobufUtil.empty()).build();
        }
    }

    public static interface Params {
        default public UrlRequest urlRequest() {
            return ((BeforeUrlRequest.Request)this).getUrlRequest();
        }

        default public Optional<Browser> browser() {
            return Optional.ofNullable(BrowserImpl.with(((BeforeUrlRequest.Request)this).getBrowserId()).orElse(null));
        }
    }
}

