/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.BytesData;
import com.teamdev.jxbrowser.net.FormData;
import com.teamdev.jxbrowser.net.MultipartFormData;
import com.teamdev.jxbrowser.net.TextData;
import com.teamdev.jxbrowser.net.UploadData;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.BeforeSendUploadData;
import com.teamdev.jxbrowser.net.internal.rpc.MultipartFormDataPair;
import com.teamdev.jxbrowser.net.internal.rpc.UploadData;

public interface BeforeSendUploadDataCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response override(BytesData bytesData) {
            Preconditions.checkNotNull(bytesData);
            return BeforeSendUploadData.Response.newBuilder().setReplaceWith(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setBytesData((com.teamdev.jxbrowser.net.internal.rpc.BytesData)bytesData).build()).build();
        }

        public static Response override(TextData textData) {
            return BeforeSendUploadData.Response.newBuilder().setReplaceWith(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setTextData((com.teamdev.jxbrowser.net.internal.rpc.TextData)textData).build()).build();
        }

        public static Response override(FormData formData) {
            return BeforeSendUploadData.Response.newBuilder().setReplaceWith(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setFormData((com.teamdev.jxbrowser.net.internal.rpc.FormData)formData).build()).build();
        }

        public static Response override(MultipartFormData multipartFormData) {
            return BeforeSendUploadData.Response.newBuilder().setReplaceWith(com.teamdev.jxbrowser.net.internal.rpc.UploadData.newBuilder().setMultipartFormData((com.teamdev.jxbrowser.net.internal.rpc.MultipartFormData)multipartFormData).build()).build();
        }

        public static Response proceed() {
            return BeforeSendUploadData.Response.newBuilder().setContinue(ProtobufUtil.empty()).build();
        }
    }

    public static interface Params {
        default public UrlRequest urlRequest() {
            return ((BeforeSendUploadData.Request)this).getUrlRequest();
        }

        default public UploadData uploadData() {
            BeforeSendUploadData.Request request = (BeforeSendUploadData.Request)this;
            com.teamdev.jxbrowser.net.internal.rpc.UploadData uploadData = request.getUploadData();
            UploadData.DataCase dataCase = uploadData.getDataCase();
            if (dataCase.equals(UploadData.DataCase.BYTES_DATA)) {
                return BytesData.of(uploadData.getBytesData().getData().toByteArray());
            }
            if (dataCase.equals(UploadData.DataCase.TEXT_DATA)) {
                return TextData.of(uploadData.getTextData().getData());
            }
            if (dataCase.equals(UploadData.DataCase.FORM_DATA)) {
                FormData.Builder builder = FormData.newBuilder();
                uploadData.getFormData().getDataList().forEach(formDataPair -> builder.addPair(FormData.Pair.of(formDataPair.getKey(), formDataPair.getValue())));
                return builder.build();
            }
            if (dataCase.equals(UploadData.DataCase.MULTIPART_FORM_DATA)) {
                MultipartFormData.Builder builder = MultipartFormData.newBuilder();
                uploadData.getMultipartFormData().getDataList().forEach(multipartFormDataPair -> {
                    if (multipartFormDataPair.getValueCase().equals(MultipartFormDataPair.ValueCase.STRING_VALUE)) {
                        builder.addPair(MultipartFormData.Pair.of(multipartFormDataPair.getKey(), multipartFormDataPair.getStringValue()));
                    }
                    if (multipartFormDataPair.getValueCase().equals(MultipartFormDataPair.ValueCase.FILE_VALUE)) {
                        builder.addPair(MultipartFormData.Pair.of(multipartFormDataPair.getKey(), multipartFormDataPair.getFileValue()));
                    }
                });
                return builder.build();
            }
            throw new IllegalStateException("Unsupported upload data case: " + dataCase);
        }
    }
}

