/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.HttpHeader;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.callback.NetworkSyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.BeforeSendHeaders;
import com.teamdev.jxbrowser.net.internal.rpc.HttpHeaderList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface BeforeSendHeadersCallback
extends NetworkSyncCallback<Params, Response> {

    public static interface Response {
        public static Response override(List<HttpHeader> httpHeaders) {
            Preconditions.checkNotNull(httpHeaders);
            HttpHeaderList.Builder builder = HttpHeaderList.newBuilder();
            httpHeaders.forEach(httpHeader -> builder.addHttpHeader((com.teamdev.jxbrowser.net.internal.rpc.HttpHeader)httpHeader));
            return BeforeSendHeaders.Response.newBuilder().setOverrideWith(builder.build()).build();
        }

        public static Response proceed() {
            return BeforeSendHeaders.Response.newBuilder().setContinue(ProtobufUtil.empty()).build();
        }
    }

    public static interface Params {
        default public UrlRequest urlRequest() {
            return ((BeforeSendHeaders.Request)this).getUrlRequest();
        }

        @Immutable
        default public List<HttpHeader> httpHeaders() {
            return Collections.unmodifiableList(((BeforeSendHeaders.Request)this).getHttpHeaderList());
        }

        default public Optional<Browser> browser() {
            return Optional.ofNullable(BrowserImpl.with(((BeforeSendHeaders.Request)this).getBrowserId()).orElse(null));
        }
    }
}

