/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net.callback;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.callback.AsyncCallbackAction;
import com.teamdev.jxbrowser.internal.rpc.ProtobufUtil;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.HostPort;
import com.teamdev.jxbrowser.net.callback.NetworkAsyncCallback;
import com.teamdev.jxbrowser.net.internal.rpc.Authenticate;
import com.teamdev.jxbrowser.net.internal.rpc.UserCredential;
import java.util.Optional;
import java.util.function.Consumer;

public interface AuthenticateCallback
extends NetworkAsyncCallback<Params, Action> {

    public static final class Action
    extends AsyncCallbackAction<Authenticate.Response> {
        public Action(Consumer<Authenticate.Response> consumer) {
            super(consumer);
        }

        public void authenticate(String userName, String password) {
            Preconditions.checkNotNullEmptyOrBlank(userName);
            Preconditions.checkNotNullEmptyOrBlank(password);
            this.send(Authenticate.Response.newBuilder().setAuthenticateWith(UserCredential.newBuilder().setUserName(userName).setPassword(password).build()).build());
        }

        public void cancel() {
            this.send(Authenticate.Response.newBuilder().setCancel(ProtobufUtil.empty()).build());
        }
    }

    public static interface Params {
        default public String url() {
            return ((Authenticate.Request)this).getUrl();
        }

        default public String scheme() {
            return ((Authenticate.Request)this).getScheme();
        }

        default public HostPort hostPort() {
            return ((Authenticate.Request)this).getHostPort();
        }

        default public boolean isProxy() {
            return ((Authenticate.Request)this).getIsProxy();
        }

        default public Optional<Browser> browser() {
            return Optional.ofNullable(BrowserImpl.with(((Authenticate.Request)this).getBrowserId()).orElse(null));
        }
    }
}

