/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.net;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestId;
import com.teamdev.jxbrowser.internal.rpc.UrlRequestJobId;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.net.HttpStatus;
import com.teamdev.jxbrowser.net.UrlRequest;
import com.teamdev.jxbrowser.net.internal.rpc.HttpHeader;
import com.teamdev.jxbrowser.net.internal.rpc.UrlRequestJobOptions;
import java.util.Collections;
import java.util.List;

public interface UrlRequestJob {
    public Id id();

    public void write(byte[] var1);

    public void complete();

    public void fail();

    public static interface Options {
        public static Builder newBuilder(UrlRequest.Id urlRequestId, HttpStatus httpStatus) {
            Preconditions.checkNotNull(urlRequestId);
            return new Builder(urlRequestId, httpStatus.value());
        }

        default public UrlRequest.Id urlRequestId() {
            return ((UrlRequestJobOptions)this).getUrlRequestId();
        }

        default public HttpStatus httpStatus() {
            return HttpStatus.of(((UrlRequestJobOptions)this).getHttpStatus());
        }

        @Immutable
        default public List<com.teamdev.jxbrowser.net.HttpHeader> httpHeaders() {
            return Collections.unmodifiableList(((UrlRequestJobOptions)this).getHttpHeaderList());
        }

        public static final class Builder {
            private final UrlRequestJobOptions.Builder builder;

            private Builder(UrlRequest.Id urlRequestId, int httpStatus) {
                this.builder = UrlRequestJobOptions.newBuilder().setUrlRequestId(UrlRequestId.newBuilder().setValue(urlRequestId.value()).build()).setHttpStatus(httpStatus);
            }

            public Builder addHttpHeader(com.teamdev.jxbrowser.net.HttpHeader httpHeader) {
                Preconditions.checkNotNull(httpHeader);
                this.builder.addHttpHeader((HttpHeader)httpHeader);
                return this;
            }

            public Options build() {
                return this.builder.build();
            }
        }
    }

    public static interface Id {
        default public String uuid() {
            return ((UrlRequestJobId)this).getUuid();
        }
    }
}

