/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.navigation.internal;

import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.deps.com.google.protobuf.Int32Value;
import com.teamdev.jxbrowser.event.Observer;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.Wrappers;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.navigation.LoadUrlParams;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.navigation.NavigationEntry;
import com.teamdev.jxbrowser.navigation.NavigationException;
import com.teamdev.jxbrowser.navigation.TimeoutException;
import com.teamdev.jxbrowser.navigation.callback.NavigationCallback;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationEvent;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.navigation.internal.rpc.Index;
import com.teamdev.jxbrowser.navigation.internal.rpc.LoadRequest;
import com.teamdev.jxbrowser.navigation.internal.rpc.NavigationStub;
import com.teamdev.jxbrowser.navigation.internal.rpc.ReloadRequest;
import com.teamdev.jxbrowser.net.NetError;
import com.teamdev.jxbrowser.time.Timestamp;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class NavigationImpl
extends CloseableImpl<NavigationImpl>
implements Navigation {
    private final BrowserImpl browser;
    private final NewServiceConnection<NavigationStub> rpc;

    public NavigationImpl(BrowserImpl browser) {
        Preconditions.checkNotNull(browser);
        this.browser = browser;
        this.rpc = new NewServiceConnection<NavigationStub>(browser.id(), browser.engine().connection(), NavigationStub::new);
    }

    @Override
    public void close() {
        this.rpc.close();
        super.close();
    }

    @Override
    public Browser browser() {
        return this.browser;
    }

    @Override
    public void loadUrl(String url) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        this.checkNotClosed();
        this.loadUrl(LoadUrlParams.newBuilder(url).build());
    }

    @Override
    public void loadUrlAndWait(String url) {
        this.loadUrlAndWait(url, DEFAULT_TIMEOUT_IN_SECONDS);
    }

    @Override
    public void loadUrlAndWait(String url, Timestamp timeout) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        Preconditions.checkArgument(timeout.toMillis() > 0L);
        this.checkNotClosed();
        this.loadUrlAndWait(LoadUrlParams.newBuilder(url).build(), timeout);
    }

    @Override
    public void loadUrl(LoadUrlParams params) {
        Preconditions.checkNotNull(params);
        this.checkNotClosed();
        LoadRequest request = Wrappers.unwrap(params, LoadRequest.class).toBuilder().setBrowserId(this.browser.id()).build();
        this.rpc.invokeAsync(this.rpc.stub()::load, request);
    }

    @Override
    public void loadUrlAndWait(LoadUrlParams params) {
        this.loadUrlAndWait(params, DEFAULT_TIMEOUT_IN_SECONDS);
    }

    @Override
    public void loadUrlAndWait(LoadUrlParams params, Timestamp timeout) {
        Preconditions.checkNotNull(params);
        Preconditions.checkArgument(timeout.toMillis() > 0L);
        this.checkNotClosed();
        this.loadAndWait(params, timeout.toSeconds()).ifPresent(netError -> {
            throw new NavigationException("Failed to load resource: " + netError, (NetError)netError);
        });
    }

    @Override
    public boolean isLoading() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::isLoading, this.browser.id())).getValue();
    }

    @Override
    public void goBack() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::goBack, this.browser.id());
    }

    @Override
    public boolean canGoBack() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::canGoBack, this.browser.id())).getValue();
    }

    @Override
    public void goForward() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::goForward, this.browser.id());
    }

    @Override
    public boolean canGoForward() {
        this.checkNotClosed();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::canGoForward, this.browser.id())).getValue();
    }

    @Override
    public void stop() {
        this.checkNotClosed();
        this.rpc.invokeAsync(this.rpc.stub()::stop, this.browser.id());
    }

    @Override
    public void reload() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadAndCheckForRepost() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setCheckForRepost(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadIgnoringCache() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setIgnoreCache(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void reloadIgnoringCacheAndCheckForRepost() {
        this.checkNotClosed();
        ReloadRequest request = ReloadRequest.newBuilder().setBrowserId(this.browser.id()).setIgnoreCache(true).setCheckForRepost(true).build();
        this.rpc.invokeAsync(this.rpc.stub()::reload, request);
    }

    @Override
    public void goToIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        this.rpc.invokeAsync(this.rpc.stub()::goToEntry, request);
    }

    @Override
    public int entryCount() {
        this.checkNotClosed();
        return ((Int32Value)this.rpc.invoke(this.rpc.stub()::getSize, this.browser.id())).getValue();
    }

    @Override
    public int currentEntryIndex() {
        this.checkNotClosed();
        return ((Int32Value)this.rpc.invoke(this.rpc.stub()::getCurrentIndex, this.browser.id())).getValue();
    }

    @Override
    public NavigationEntry entryAtIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        return (NavigationEntry)this.rpc.invoke(this.rpc.stub()::getEntry, request);
    }

    @Override
    public boolean removeEntryAtIndex(int index) {
        Preconditions.checkArgument(index >= 0 && index < this.entryCount() && index != this.currentEntryIndex());
        this.checkNotClosed();
        Index request = Index.newBuilder().setBrowserId(this.browser.id()).setValue(index).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeEntry, request)).getValue();
    }

    private Optional<NetError> loadAndWait(LoadUrlParams params, long timeoutInSeconds) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference netError = new AtomicReference();
        Subscription frameLoadFinished = this.on(FrameLoadFinished.class, event -> {
            if (event.frame().isMain()) {
                latch.countDown();
            }
        });
        Subscription navigationFinished = this.on(NavigationFinished.class, event -> {
            boolean isAborted;
            boolean hasCommitted = event.hasCommitted();
            boolean isErrorPage = event.isErrorPage();
            boolean bl = isAborted = event.error() == NetError.ABORTED;
            if (hasCommitted && isErrorPage || isAborted) {
                netError.set(event.error());
                latch.countDown();
            }
            if (hasCommitted && event.isSameDocument()) {
                latch.countDown();
            }
        });
        Subscription frameLoadFailed = this.on(FrameLoadFailed.class, event -> {
            netError.set(event.error());
            latch.countDown();
        });
        this.loadUrl(params);
        try {
            if (!latch.await(timeoutInSeconds, TimeUnit.SECONDS)) {
                throw new TimeoutException("Failed to execute task withing " + timeoutInSeconds + " seconds.");
            }
        }
        catch (InterruptedException e) {
            throw new TimeoutException("The current thread has been interrupted.", e);
        }
        finally {
            frameLoadFinished.unsubscribe();
            navigationFinished.unsubscribe();
            frameLoadFailed.unsubscribe();
        }
        return Optional.ofNullable(netError.get());
    }

    @Override
    public <E extends NavigationEvent> Subscription on(Class<E> eventClass, Observer<E> observer) {
        return this.rpc.on(eventClass, observer);
    }

    @Override
    public <C extends NavigationCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((NavigationCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends NavigationCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends NavigationCallback> C remove(Class<C> callbackClass) {
        return (C)((NavigationCallback)this.rpc.remove(callbackClass));
    }
}

