/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.navigation;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.navigation.internal.rpc.LoadRequest;
import com.teamdev.jxbrowser.net.internal.rpc.HttpHeader;
import java.util.Collections;
import java.util.List;

public interface LoadUrlParams {
    public static Builder newBuilder(String url) {
        Preconditions.checkNotNullEmptyOrBlank(url);
        return new Builder(url);
    }

    default public String url() {
        return ((LoadRequest)this).getUrl();
    }

    default public String postData() {
        return ((LoadRequest)this).getPostData();
    }

    @Immutable
    default public List<com.teamdev.jxbrowser.net.HttpHeader> extraHeaders() {
        return Collections.unmodifiableList(((LoadRequest)this).getHttpHeaderList());
    }

    public static final class Builder {
        private final LoadRequest.Builder builder;

        private Builder(String url) {
            this.builder = LoadRequest.newBuilder().setUrl(url);
        }

        public Builder postData(String postData) {
            Preconditions.checkNotNull(postData);
            this.builder.setPostData(postData);
            return this;
        }

        public Builder addExtraHeader(com.teamdev.jxbrowser.net.HttpHeader httpHeader) {
            Preconditions.checkNotNull(httpHeader);
            this.builder.addHttpHeader((HttpHeader)httpHeader);
            return this;
        }

        public LoadUrlParams build() {
            return this.builder.build();
        }
    }
}

