/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.media.internal;

import com.teamdev.jxbrowser.engine.internal.EngineImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.media.MediaDevice;
import com.teamdev.jxbrowser.media.MediaDeviceType;
import com.teamdev.jxbrowser.media.MediaDevices;
import com.teamdev.jxbrowser.media.callback.MediaCallback;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceList;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceManagerStub;
import com.teamdev.jxbrowser.media.internal.rpc.MediaDeviceTypeValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class MediaDevicesImpl
extends CloseableImpl
implements MediaDevices {
    private final NewServiceConnection<MediaDeviceManagerStub> rpc;

    public MediaDevicesImpl(EngineImpl engine) {
        Preconditions.checkNotNull(engine);
        this.rpc = new NewServiceConnection<MediaDeviceManagerStub>(engine.id(), engine.connection(), MediaDeviceManagerStub::new);
    }

    @Override
    public List<MediaDevice> list(MediaDeviceType type) {
        this.checkNotClosed();
        MediaDeviceTypeValue request = MediaDeviceTypeValue.newBuilder().setMediaDeviceType(type).build();
        return Collections.unmodifiableList(((MediaDeviceList)this.rpc.invoke(this.rpc.stub()::getDevices, request)).getMediaDeviceList());
    }

    @Override
    public <C extends MediaCallback> C set(Class<C> callbackClass, C callback) {
        return (C)((MediaCallback)this.rpc.set(callbackClass, callback));
    }

    @Override
    public <C extends MediaCallback> Optional<C> get(Class<C> callbackClass) {
        return this.rpc.get(callbackClass);
    }

    @Override
    public <C extends MediaCallback> C remove(Class<C> callbackClass) {
        return (C)((MediaCallback)this.rpc.remove(callbackClass));
    }
}

