/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.media.callback;

import com.teamdev.jxbrowser.annotation.Immutable;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.internal.BrowserImpl;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.media.MediaDevice;
import com.teamdev.jxbrowser.media.MediaDeviceType;
import com.teamdev.jxbrowser.media.callback.MediaSyncCallback;
import com.teamdev.jxbrowser.media.internal.rpc.SelectMediaDevice;
import java.util.Collections;
import java.util.List;

public interface SelectMediaDeviceCallback
extends MediaSyncCallback<Params, Response> {

    public static interface Response {
        public static Response select(MediaDevice mediaDevice) {
            Preconditions.checkNotNull(mediaDevice);
            return SelectMediaDevice.Response.newBuilder().setSelectedMediaDevice((com.teamdev.jxbrowser.media.internal.rpc.MediaDevice)mediaDevice).build();
        }
    }

    public static interface Params {
        default public Browser browser() {
            return BrowserImpl.with(((SelectMediaDevice.Request)this).getBrowserId()).orElseThrow(IllegalStateException::new);
        }

        default public MediaDeviceType mediaDeviceType() {
            return ((SelectMediaDevice.Request)this).getType();
        }

        @Immutable
        default public List<MediaDevice> mediaDevices() {
            return Collections.unmodifiableList(((SelectMediaDevice.Request)this).getMediaDeviceList().getMediaDeviceList());
        }
    }
}

