/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.logging;

import com.teamdev.jxbrowser.logging.Level;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

enum LoggerProvider {
    INSTANCE;

    private static final String ROOT_LOGGER_NAME = "com.teamdev.jxbrowser";
    private final Logger logger;

    private LoggerProvider() {
        String loggingLevel = System.getProperty("jxbrowser.logging.level", Level.ERROR.name());
        this.logger = Logger.getLogger(ROOT_LOGGER_NAME);
        this.logger.setUseParentHandlers(false);
        java.util.logging.Level defaultLevel = Level.valueOf(loggingLevel).julLevel();
        this.logger.addHandler(LoggerProvider.createHandler(defaultLevel));
        this.logger.setLevel(defaultLevel);
    }

    static Handler createHandler(java.util.logging.Level level) {
        String logFile = System.getProperty("jxbrowser.logging.file");
        if (logFile != null && !logFile.isEmpty()) {
            try {
                FileHandler fileHandler = new FileHandler(logFile);
                fileHandler.setFormatter(new SimpleFormatter());
                fileHandler.setLevel(level);
                return fileHandler;
            }
            catch (IOException e) {
                System.err.println("Failed to create the log file.");
                e.printStackTrace();
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        consoleHandler.setLevel(level);
        return consoleHandler;
    }

    static Logger logger() {
        return LoggerProvider.INSTANCE.logger;
    }

    private static final class SimpleFormatter
    extends Formatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss.SSS", Locale.getDefault());

        private SimpleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.dateFormat.format(new Date(record.getMillis()))).append(' ').append(SimpleFormatter.name(record.getLevel())).append(' ').append(this.formatMessage(record)).append(LINE_SEPARATOR);
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    thrown.printStackTrace(printWriter);
                    printWriter.close();
                    builder.append(stringWriter.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return builder.toString();
        }

        private static String name(java.util.logging.Level level) {
            if (level.equals(Level.ERROR.julLevel())) {
                return "ERROR";
            }
            if (level.equals(Level.WARNING.julLevel())) {
                return "WARNING";
            }
            if (level.equals(Level.INFO.julLevel())) {
                return "INFO";
            }
            if (level.equals(Level.DEBUG.julLevel())) {
                return "DEBUG";
            }
            return level.getName();
        }
    }
}

