/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.logging;

import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.logging.Level;
import com.teamdev.jxbrowser.logging.LoggerProvider;
import java.util.function.Supplier;
import java.util.logging.Handler;

public final class Logger {
    private static final java.util.logging.Logger log = LoggerProvider.logger();

    public static Level level() {
        return Level.valueOf(log.getLevel()).orElseThrow(() -> new IllegalStateException("Unsupported Java logging level: " + log.getLevel()));
    }

    public static void level(Level level) {
        Preconditions.checkNotNull(level);
        log.setLevel(level.julLevel());
        for (Handler handler : log.getHandlers()) {
            handler.setLevel(level.julLevel());
        }
    }

    public static void error(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.ERROR.julLevel(), message);
    }

    public static void error(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.ERROR.julLevel(), message, arguments);
    }

    public static void error(String message, Throwable exception) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        log.log(Level.ERROR.julLevel(), message, exception);
    }

    public static void info(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.INFO.julLevel(), message);
    }

    public static void warn(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.WARNING.julLevel(), message);
    }

    public static void warn(String message, Throwable exception) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(exception);
        log.log(Level.WARNING.julLevel(), message, exception);
    }

    public static void warn(Throwable exception, Supplier<String> msgSupplier) {
        Preconditions.checkNotNull(exception);
        Preconditions.checkNotNull(msgSupplier);
        log.log(Level.WARNING.julLevel(), exception, msgSupplier);
    }

    public static void debug(String message) {
        Preconditions.checkNotNull(message);
        log.log(Level.DEBUG.julLevel(), message);
    }

    public static void debug(String message, Object ... arguments) {
        Preconditions.checkNotNull(message);
        Preconditions.checkNotNull(arguments);
        log.log(Level.DEBUG.julLevel(), message, arguments);
    }

    public static boolean isErrorEnabled() {
        return log.isLoggable(Level.ERROR.julLevel());
    }

    public static boolean isWarnEnabled() {
        return log.isLoggable(Level.WARNING.julLevel());
    }

    public static boolean isInfoEnabled() {
        return log.isLoggable(Level.INFO.julLevel());
    }

    public static boolean isDebugEnabled() {
        return log.isLoggable(Level.DEBUG.julLevel());
    }
}

