/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.js.Json;
import javax.annotation.Nullable;

public final class JsonImpl
implements Json {
    private final Frame frame;

    public JsonImpl(Frame frame) {
        this.frame = frame;
    }

    @Override
    @Nullable
    public <T> T parse(String json) {
        Preconditions.checkNotNullEmptyOrBlank(json);
        JsObject jsonObject = (JsObject)this.frame.executeJavaScript("JSON");
        Preconditions.checkNotNull(jsonObject);
        return jsonObject.call("parse", json);
    }

    @Override
    public String stringify(JsObject jsObject) {
        Preconditions.checkNotNull(jsObject);
        JsObject jsonObject = (JsObject)this.frame.executeJavaScript("JSON");
        Preconditions.checkNotNull(jsonObject);
        return (String)jsonObject.call("stringify", jsObject);
    }
}

