/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.deps.com.google.protobuf.BoolValue;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.FrameId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.NewServiceConnection;
import com.teamdev.jxbrowser.internal.rpc.transport.Connection;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.JsException;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.js.internal.JsContext;
import com.teamdev.jxbrowser.js.internal.rpc.JsMethodInfo;
import com.teamdev.jxbrowser.js.internal.rpc.JsObjectInfo;
import com.teamdev.jxbrowser.js.internal.rpc.JsObjectStub;
import com.teamdev.jxbrowser.js.internal.rpc.JsPropertyInfo;
import com.teamdev.jxbrowser.js.internal.rpc.JsPropertyValue;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import com.teamdev.jxbrowser.js.internal.rpc.PropertyNameList;
import com.teamdev.jxbrowser.js.internal.rpc.ReturnValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsObjectImpl
extends CloseableImpl<JsObjectImpl>
implements JsObject {
    private final JsObjectId id;
    private final JsContext jsContext;
    private final NewServiceConnection<JsObjectStub> rpc;

    public JsObjectImpl(Connection connection, JsContext jsContext, JsObjectId jsObjectId) {
        Preconditions.checkNotNull(connection);
        Preconditions.checkNotNull(jsContext);
        Preconditions.checkNotNull(jsObjectId);
        this.id = jsObjectId;
        this.jsContext = jsContext;
        this.rpc = new NewServiceConnection<JsObjectStub>(jsObjectId, connection, JsObjectStub::new);
        jsContext.registerJsObject(this);
    }

    private FrameId frameId() {
        return this.jsContext.frame().id();
    }

    public final JsObjectId id() {
        return this.id;
    }

    public final JsContext jsContext() {
        return this.jsContext;
    }

    @Override
    public void close() {
        this.jsContext.unregisterJsObject(this);
        super.close();
    }

    @Override
    public final List<String> propertyNames() {
        this.checkNotClosed();
        JsObjectInfo request = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        return Collections.unmodifiableList(((PropertyNameList)this.rpc.invoke(this.rpc.stub()::getPropertyNames, request)).getPropertyNameList());
    }

    @Override
    public final List<String> ownPropertyNames() {
        this.checkNotClosed();
        JsObjectInfo request = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        return Collections.unmodifiableList(((PropertyNameList)this.rpc.invoke(this.rpc.stub()::getOwnPropertyNames, request)).getPropertyNameList());
    }

    @Override
    public final boolean hasProperty(String name) {
        Preconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsObjectInfo jsObjectInfo = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        JsPropertyInfo request = JsPropertyInfo.newBuilder().setJsObjectInfo(jsObjectInfo).setPropertyName(name).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::hasProperty, request)).getValue();
    }

    @Override
    public final <T> Optional<T> property(String name) {
        Preconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsObjectInfo jsObjectInfo = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        JsPropertyInfo request = JsPropertyInfo.newBuilder().setJsObjectInfo(jsObjectInfo).setPropertyName(name).build();
        JsValue response = (JsValue)this.rpc.invoke(this.rpc.stub()::getProperty, request);
        return Optional.ofNullable(this.jsContext.toObject(response));
    }

    @Override
    public final boolean putProperty(String name, Object value) {
        Preconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsValue jsValue = this.jsContext.toValue(value);
        JsObjectInfo jsObjectInfo = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        JsPropertyInfo jsPropertyInfo = JsPropertyInfo.newBuilder().setJsObjectInfo(jsObjectInfo).setPropertyName(name).build();
        JsPropertyValue request = JsPropertyValue.newBuilder().setJsPropertyInfo(jsPropertyInfo).setJsPropertyValue(jsValue).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::setProperty, request)).getValue();
    }

    @Override
    public final boolean removeProperty(String name) {
        Preconditions.checkNotNullEmptyOrBlank(name);
        this.checkNotClosed();
        JsObjectInfo jsObjectInfo = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        JsPropertyInfo request = JsPropertyInfo.newBuilder().setJsObjectInfo(jsObjectInfo).setPropertyName(name).build();
        return ((BoolValue)this.rpc.invoke(this.rpc.stub()::removeProperty, request)).getValue();
    }

    @Override
    public final <T> T call(String methodName, Object ... args) {
        Preconditions.checkNotNullEmptyOrBlank(methodName);
        this.checkNotClosed();
        Collection<JsValue> jsArgs = this.jsContext.toValues(args);
        JsObjectInfo jsObjectInfo = JsObjectInfo.newBuilder().setFrameId(this.frameId()).setJsObjectId(this.id).build();
        JsMethodInfo request = JsMethodInfo.newBuilder().setJsObjectInfo(jsObjectInfo).setMethodName(methodName).addAllArgs(jsArgs).build();
        ReturnValue response = (ReturnValue)this.rpc.invoke(this.rpc.stub()::callMethod, request);
        if (response.getValueCase() == ReturnValue.ValueCase.JS_VALUE) {
            return this.jsContext.toObject(response.getJsValue());
        }
        throw new JsException(response.getJsError().getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsObjectImpl jsObject = (JsObjectImpl)o;
        return Objects.equals(this.id, jsObject.id) && Objects.equals(this.jsContext, jsObject.jsContext);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jsContext);
    }
}

