/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.dom.event.internal.EventTargetImpl;
import com.teamdev.jxbrowser.dom.internal.rpc.NodeInfo;
import com.teamdev.jxbrowser.frame.internal.FrameImpl;
import com.teamdev.jxbrowser.internal.CloseableImpl;
import com.teamdev.jxbrowser.internal.rpc.JsObjectId;
import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import com.teamdev.jxbrowser.internal.util.Preconditions;
import com.teamdev.jxbrowser.js.JsFunctionCallback;
import com.teamdev.jxbrowser.js.internal.JavaObjectRegistry;
import com.teamdev.jxbrowser.js.internal.JsObjectImpl;
import com.teamdev.jxbrowser.js.internal.rpc.JsValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class JsContext
extends CloseableImpl<JsContext> {
    private final FrameImpl frame;
    private final Map<JsObjectId, JsObjectImpl> jsObjects;
    private final JavaObjectRegistry javaObjectRegistry;

    public JsContext(FrameImpl frame) {
        this.frame = frame;
        this.jsObjects = new ConcurrentHashMap<JsObjectId, JsObjectImpl>();
        this.javaObjectRegistry = new JavaObjectRegistry();
    }

    public FrameImpl frame() {
        return this.frame;
    }

    @Override
    public void close() {
        this.jsObjects.forEach((jsObjectId, jsObject) -> jsObject.close());
        super.close();
    }

    void registerJsObject(JsObjectImpl jsObject) {
        this.jsObjects.putIfAbsent(jsObject.id(), jsObject);
    }

    void unregisterJsObject(JsObjectImpl jsObject) {
        this.jsObjects.remove(jsObject.id());
    }

    private JsObjectProxyId registerJavaObject(Object object) {
        return this.javaObjectRegistry.registerJavaObject(object);
    }

    public Optional<Object> javaObject(JsObjectProxyId objectProxyId) {
        return this.javaObjectRegistry.javaObject(objectProxyId);
    }

    public <T> T toObject(JsValue jsValue) {
        NodeInfo nodeInfo;
        Optional<Object> optionalObject;
        if (jsValue.getIsNullOrUndefined()) {
            return null;
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.BOOL_VALUE) {
            return (T)Boolean.valueOf(jsValue.getBoolValue());
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.NUMBER_VALUE) {
            return (T)Double.valueOf(jsValue.getNumberValue());
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.STRING_VALUE) {
            return (T)jsValue.getStringValue();
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.OBJECT_ID_VALUE) {
            return (T)new JsObjectImpl(this.frame.renderProcess().connection(), this, jsValue.getObjectIdValue());
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.OBJECT_PROXY_ID_VALUE && (optionalObject = this.javaObject(jsValue.getObjectProxyIdValue())).isPresent()) {
            return (T)optionalObject.get();
        }
        if (jsValue.getValueCase() == JsValue.ValueCase.NODE_INFO && (nodeInfo = jsValue.getNodeInfo()).getNodeId().getValue() != 0) {
            return (T)this.frame.domContext().toNode(nodeInfo);
        }
        throw new IllegalArgumentException("Unsupported JS value: " + jsValue.getValueCase());
    }

    public JsValue toValue(@Nullable Object object) {
        JsValue.Builder builder = JsValue.newBuilder();
        if (object instanceof EventTargetImpl) {
            EventTargetImpl eventTarget = (EventTargetImpl)object;
            Preconditions.checkArgument(eventTarget.jsContext().equals(this));
            builder.setNodeInfo(eventTarget.nodeInfo());
        } else if (object instanceof JsFunctionCallback) {
            builder.setFunctionIdValue(this.registerJavaObject(object));
        } else if (object instanceof JsObjectImpl) {
            JsObjectImpl jsObject = (JsObjectImpl)object;
            Preconditions.checkArgument(jsObject.jsContext().equals(this));
            builder.setObjectIdValue(jsObject.id());
        } else if (object instanceof Number) {
            builder.setNumberValue(((Number)object).doubleValue());
        } else if (object instanceof Boolean) {
            builder.setBoolValue((Boolean)object);
        } else if (object instanceof String) {
            builder.setStringValue((String)object);
        } else if (object == null) {
            builder.setIsNullOrUndefined(true);
        } else {
            builder.setObjectProxyIdValue(this.registerJavaObject(object));
        }
        return builder.build();
    }

    Collection<JsValue> toValues(Object ... objects) {
        ArrayList<JsValue> result = new ArrayList<JsValue>();
        for (Object object : objects) {
            result.add(this.toValue(object));
        }
        return result;
    }
}

