/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.js.internal;

import com.teamdev.jxbrowser.internal.rpc.JsObjectProxyId;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public final class JavaObjectRegistry {
    private static final AtomicInteger jsObjectProxyIdGenerator = new AtomicInteger();
    private final Map<JsObjectProxyId, Object> idObjectMap = new HashMap<JsObjectProxyId, Object>();
    private final Map<Integer, JsObjectProxyId> objectIdMap = new HashMap<Integer, JsObjectProxyId>();

    public synchronized JsObjectProxyId registerJavaObject(Object object) {
        Integer hashCode = System.identityHashCode(object);
        if (this.objectIdMap.containsKey(hashCode)) {
            return this.objectIdMap.get(hashCode);
        }
        JsObjectProxyId objectProxyId = JsObjectProxyId.newBuilder().setValue(jsObjectProxyIdGenerator.incrementAndGet()).build();
        this.idObjectMap.put(objectProxyId, object);
        this.objectIdMap.put(hashCode, objectProxyId);
        return objectProxyId;
    }

    public synchronized Optional<Object> javaObject(JsObjectProxyId id) {
        return Optional.ofNullable(this.idObjectMap.get(id));
    }
}

