/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.internal.ChromiumArchiveName;
import com.teamdev.jxbrowser.internal.ChromiumExtractorException;
import com.teamdev.jxbrowser.internal.FileUtil;
import com.teamdev.jxbrowser.internal.xz.ResourceLocator;
import com.teamdev.jxbrowser.internal.xz.XZ;
import com.teamdev.jxbrowser.internal.xz.XzUtilName;
import com.teamdev.jxbrowser.os.Environment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;

public final class XzExtractor {
    public static void extract(Path destDir, ChromiumArchiveName xzArchiveName) {
        XzExtractor.canCreateDir(destDir);
        FileUtil.createDirs(destDir);
        String xzUtilName = XzUtilName.get();
        Path xzArchiveFile = destDir.resolve(xzArchiveName.value());
        Path xzUtilFile = destDir.resolve(xzUtilName);
        try {
            XzExtractor.extractResourceToFile(xzArchiveName.value(), xzArchiveFile);
            XzExtractor.extractResourceToFile(xzUtilName, xzUtilFile);
            if (!Environment.isWindows()) {
                FileUtil.restorePermissionsForFile(xzUtilFile);
            }
            XZ.decompress(xzUtilFile.toAbsolutePath().toString(), xzArchiveFile.toAbsolutePath().toString(), destDir.toAbsolutePath().toString());
        }
        catch (IOException | InterruptedException e) {
            throw new ChromiumExtractorException("Failed to extract Chromium binaries into " + destDir.toAbsolutePath(), e);
        }
        finally {
            FileUtil.deleteFile(xzArchiveFile);
            FileUtil.deleteFile(xzUtilFile);
        }
    }

    public static Optional<URL> findResourceURL(String resourceName) {
        List<ResourceLocator> locators = ResourceLocator.allLocators();
        for (ResourceLocator locator : locators) {
            Optional<URL> resource = locator.find(resourceName);
            if (!resource.isPresent()) continue;
            return resource;
        }
        return Optional.empty();
    }

    private XzExtractor() {
    }

    private static void canCreateDir(Path destDir) {
        if (Files.exists(destDir, new LinkOption[0]) && !Files.isDirectory(destDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot create directory to extract Chromium. File with the same name already exists: " + destDir.toAbsolutePath());
        }
    }

    private static void extractResourceToFile(String resourceName, Path destFile) throws IOException {
        if (Files.exists(destFile, new LinkOption[0])) {
            FileUtil.deleteFile(destFile);
        }
        Files.createFile(destFile, new FileAttribute[0]);
        URL resourceURL = XzExtractor.findResourceURL(resourceName).orElseThrow(() -> new FileNotFoundException("The resource " + resourceName + " is not found."));
        try (InputStream inputStream = resourceURL.openStream();
             FileChannel output = FileChannel.open(destFile, StandardOpenOption.WRITE);){
            XzExtractor.extract(inputStream, output);
        }
    }

    private static void extract(InputStream source, FileChannel dest) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(source);
        dest.transferFrom(channel, 0L, source.available());
    }
}

