/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.logging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

class XZ {
    XZ() {
    }

    static void decompress(String xzUtilPath, String archivePath, String destDir) throws IOException, InterruptedException {
        String[] args = new String[]{xzUtilPath, "-aoa", "-o" + destDir, "x", archivePath};
        Process exec = Runtime.getRuntime().exec(args);
        XZ.startLogging(exec);
        exec.waitFor();
    }

    private static void startLogging(Process process) {
        Thread processConsoleThread = new Thread(() -> {
            try {
                String line;
                InputStream inputStream = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                BufferedReader input = new BufferedReader(inputStreamReader);
                StringBuilder builder = new StringBuilder();
                while ((line = input.readLine()) != null) {
                    builder.append(line).append("\n");
                }
                Logger.info(builder.toString());
                input.close();
            }
            catch (IOException e) {
                Logger.error("Failed to log process output.", e);
            }
        }, "XZ Logger");
        processConsoleThread.setDaemon(true);
        processConsoleThread.start();
    }
}

