/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.internal.xz;

import com.teamdev.jxbrowser.VersionInfo;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public interface ResourceLocator {
    public static List<ResourceLocator> allLocators() {
        return Arrays.asList(ResourceLocator.legacyLocator(), ResourceLocator.moduleLocator());
    }

    public Optional<URL> find(String var1);

    public static ResourceLocator legacyLocator() {
        return resourceName -> {
            String resourcePath = "/" + VersionInfo.version() + "/" + resourceName;
            return Optional.ofNullable(ResourceLocator.class.getResource(resourcePath));
        };
    }

    public static ResourceLocator moduleLocator() {
        return resourceName -> {
            String resourcePath = VersionInfo.version() + "/" + resourceName;
            return Optional.ofNullable(ClassLoader.getSystemResource(resourcePath));
        };
    }
}

